package com.tykj.dev.device.task.controller;

import com.tykj.dev.config.GlobalMap;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.*;
import com.tykj.dev.device.task.utils.TaskUtils;
import com.tykj.dev.device.user.subject.dao.UserRecordDao;
import com.tykj.dev.device.user.subject.entity.UserRecord;
import com.tykj.dev.device.user.subject.service.UserRecordService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块", description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class TaskController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private TaskUtils taskUtils;

    @Autowired
    private TaskLogService taskLogService;

    @Autowired
    private TaskDao taskDao;

    @Autowired
    private UserRecordService userRecordService;

    @Autowired
    private UserRecordDao userRecordDao;

    @Autowired
    private DeviceLibraryService deviceLibraryService;


    @ApiOperation(value = "业务分页查询", notes = "可以通过这个接口分页查询业务")
    @RequestMapping(method = RequestMethod.POST, value = "/manage/summary", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity getTaskPage(@RequestBody TaskSelectVo taskSelectVo) {
        Boolean hasTitleDim = taskSelectVo.getTitleDim()!=null;
        Boolean hasStatusDim = taskSelectVo.getStatusDim()!=null;
        Boolean hasCreateUserDim = taskSelectVo.getCreateUserDim()!=null;
        Boolean hasProcessingUserDim = taskSelectVo.getProcessingUserDim()!=null;
        List<TaskUserVo> taskUserVos = taskService.getManageList(taskSelectVo);
        if (hasTitleDim||hasStatusDim||hasCreateUserDim||hasProcessingUserDim) {
            taskUserVos = taskUserVos.stream().filter(taskUserVo -> {
                Boolean containTitleDim = !hasTitleDim||taskUserVo.getTitle().contains(taskSelectVo.getTitleDim());
                Boolean containStatusDim = !hasStatusDim||taskUserVo.getStatus().contains(taskSelectVo.getStatusDim());
                Boolean containCreateUserDim = !hasCreateUserDim||taskUserVo.getCreateUser().contains(taskSelectVo.getCreateUserDim());
                Boolean containProcessingUserDim = !hasProcessingUserDim||taskUserVo.getProcessingUser().contains(taskSelectVo.getProcessingUserDim());
                return containTitleDim&&containStatusDim&&containCreateUserDim&&containProcessingUserDim;
            }).collect(Collectors.toList());
        }
        Page<TaskUserVo> taskUserVos1 = PageUtil.getPerPage(taskSelectVo.getPage(), taskSelectVo.getSize(), taskUserVos, taskSelectVo.getPageable());
        Map<String,Object> map = new HashMap<>();
        Map<Integer,String> businessMap = GlobalMap.getBusinessMap();
        Set<Integer> businessType = taskUserVos.stream().map(TaskUserVo::getBusinessType).collect(Collectors.toSet());
        map.put("pages",taskUserVos1);
        map.put("businessTypes",businessType.stream().map(integer -> new BusinessTypeVo(integer,businessMap.get(integer))).collect(Collectors.toList()));
        return ResultUtil.success(map);
    }
    @ApiOperation(value = "业务分页查询", notes = "可以通过这个接口分页查询业务")
    @RequestMapping(method = RequestMethod.POST, value = "/manage/summary1", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity getTaskPage1(@RequestBody TaskSelectVo taskSelectVo) {
        Boolean hasTitleDim = taskSelectVo.getTitleDim()!=null;
        Boolean hasStatusDim = taskSelectVo.getStatusDim()!=null;
        Boolean hasCreateUserDim = taskSelectVo.getCreateUserDim()!=null;
        Boolean hasProcessingUserDim = taskSelectVo.getProcessingUserDim()!=null;
        List<TaskUserVo> taskUserVos = taskService.getManageList1(taskSelectVo);
        if (hasTitleDim||hasStatusDim||hasCreateUserDim||hasProcessingUserDim) {
            taskUserVos = taskUserVos.stream().filter(taskUserVo -> {
                Boolean containTitleDim = !hasTitleDim||taskUserVo.getTitle().contains(taskSelectVo.getTitleDim());
                Boolean containStatusDim = !hasStatusDim||taskUserVo.getStatus().contains(taskSelectVo.getStatusDim());
                Boolean containCreateUserDim = !hasCreateUserDim||taskUserVo.getCreateUser().contains(taskSelectVo.getCreateUserDim());
                Boolean containProcessingUserDim = !hasProcessingUserDim||taskUserVo.getProcessingUser().contains(taskSelectVo.getProcessingUserDim());
                return containTitleDim&&containStatusDim&&containCreateUserDim&&containProcessingUserDim;
            }).collect(Collectors.toList());
        }
        Page<TaskUserVo> taskUserVos1 = PageUtil.getPerPage(taskSelectVo.getPage(), taskSelectVo.getSize(), taskUserVos, taskSelectVo.getPageable());
        Map<String,Object> map = new HashMap<>();
        Map<Integer,String> businessMap = GlobalMap.getBusinessMap();
        Set<Integer> businessType = taskUserVos.stream().map(TaskUserVo::getBusinessType).collect(Collectors.toSet());
        map.put("pages",taskUserVos1);
        map.put("businessTypes",businessType.stream().map(integer -> new BusinessTypeVo(integer,businessMap.get(integer))).collect(Collectors.toList()));
        return ResultUtil.success(map);
    }


    @ApiOperation(value = "新增待办列表查询", notes = "可以通过这个接口查询业务")
    @RequestMapping(method = RequestMethod.POST, value = "/getNewTaskList", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity getNewTaskList(@RequestBody TaskSelectVo taskSelectVo) {
        Integer userId = userUtils.getCurrentUserId();
        List<UserRecord> userRecords = userRecordDao.findAllByUserId(userId);
        if (userRecords.isEmpty()){
            return ResponseEntity.ok(Collections.EMPTY_LIST);
        }
        else {
            UserRecord userRecord = userRecords.get(0);
            List<Integer> newTaskIds;
            if (taskSelectVo.getType()==1) {
                newTaskIds = StringSplitUtil.userIdSplit(userRecord.getNewTaskIds());
            }
            else {
                newTaskIds = StringSplitUtil.userIdSplit(userRecord.getNewCountryTaskIds());
            }
            taskSelectVo.setSelectNum(2);
            List<TaskUserVo> taskUserVos = taskService.getList(taskSelectVo).stream().filter(taskUserVo -> newTaskIds.contains(taskUserVo.getId())).collect(Collectors.toList());
            return ResponseEntity.ok(taskUtils.orderByTrackingTimeDateDesc(taskUserVos));
        }
    }

    @ApiOperation(value = "业务跟踪待办列表查询", notes = "可以通过这个接口查询业务")
    @RequestMapping(method = RequestMethod.POST, value = "/getTaskList", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity getTaskList(@RequestBody TaskSelectVo taskSelectVo) {
        Boolean hasCondition = taskSelectVo.getContent()!=null||taskSelectVo.getStartTime()!=null||taskSelectVo.getEndTime()!=null||
                (taskSelectVo.getBusinessType()!=null&&taskSelectVo.getBusinessType().size()>0)||taskSelectVo.getBillStatus()!=null||
                (taskSelectVo.getRemark()!=null&&taskSelectVo.getRemark().size()>0)||taskSelectVo.getTitleDim()!=null||
                taskSelectVo.getStatusDim()!=null||taskSelectVo.getCreateUserDim()!=null||taskSelectVo.getProcessingUserDim()!=null;
        Integer userId = userUtils.getCurrentUserId();
        List<TaskUserVo> taskUserVos = taskService.getList(taskSelectVo);
        if (!hasCondition){
            List<Integer> taskIds = taskUserVos.stream().map(TaskUserVo::getId).collect(Collectors.toList());
            List<UserRecord> userRecords = userRecordDao.findAllByUserId(userId);
            //2代表配发
            if (taskSelectVo.getSelectNum()==2) {
                //待办类型(1:省内待办，2：省外待办)
                if (taskSelectVo.getType() == 1) {
                    if (userRecords.isEmpty()) {
                        UserRecord userRecord = new UserRecord();
                        userRecord.setUserId(userId);
                        userRecord.setTaskIds(StringSplitUtil.idListToString(taskIds));
                        userRecord.setNewTaskIds(userRecord.getTaskIds());
                        userRecordService.save(userRecord);
                    } else {
                        UserRecord userRecord = userRecords.get(0);
                        if (userRecord.getTaskIds() == null) {
                            userRecord.setTaskIds(StringSplitUtil.idListToString(taskIds));
                            userRecord.setNewTaskIds(userRecord.getTaskIds());
                            userRecordService.save(userRecord);
                        } else {
                            List<Integer> ids = StringSplitUtil.userIdSplit(userRecord.getTaskIds());
                            userRecord.setTaskIds(StringSplitUtil.idListToString(taskIds));
                            taskIds.removeAll(ids);
                            userRecord.setNewTaskIds(StringSplitUtil.idListToString(taskIds));
                            userRecordService.save(userRecord);
                        }
                    }
                } else {
                    if (userRecords.isEmpty()) {
                        UserRecord userRecord = new UserRecord();
                        userRecord.setUserId(userId);
                        userRecord.setCountryTaskIds(StringSplitUtil.idListToString(taskIds));
                        userRecord.setNewCountryTaskIds(userRecord.getCountryTaskIds());
                        userRecordService.save(userRecord);
                    } else {
                        UserRecord userRecord = userRecords.get(0);
                        if (userRecord.getCountryTaskIds() == null) {
                            userRecord.setCountryTaskIds(StringSplitUtil.idListToString(taskIds));
                            userRecord.setNewCountryTaskIds(userRecord.getCountryTaskIds());
                            userRecordService.save(userRecord);
                        } else {
                            List<Integer> ids = StringSplitUtil.userIdSplit(userRecord.getCountryTaskIds());
                            userRecord.setCountryTaskIds(StringSplitUtil.idListToString(taskIds));
                            taskIds.removeAll(ids);
                            userRecord.setNewCountryTaskIds(StringSplitUtil.idListToString(taskIds));
                            userRecordService.save(userRecord);
                        }
                    }
                }
                //set新增的task高亮字段
                taskUserVos.forEach(taskUserVo -> {
                    if (taskIds.contains(taskUserVo.getId())){
                        taskUserVo.setIsNew(1);
                    }
                });
            }
        }
        return ResultUtil.success(taskUtils.orderByTopDescAndReadAsc(taskUserVos));
    }

    @ApiOperation(value = "置顶设置", notes = "可以通过这个接口置顶业务")
    @RequestMapping(method = RequestMethod.PUT, value = "/setTop", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity setTop(@RequestBody @Validated TaskTopVo taskTopVo) {
        TaskBto taskBto = taskService.get(taskTopVo.getTaskId());
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = taskBto.getTopFlagDetailList();
        if (taskTopVo.getTopFlag() == 1) {
            if (userIds != null) {
                taskBto.getTopFlagDetailList().add(userId);
            }
        }
        if (taskTopVo.getTopFlag() == 0) {
            if (userIds != null && userIds.contains(userId)) {
                userIds.removeAll(new ArrayList<>(Collections.singletonList(userId)));
            }
        }
        Task task = taskService.update(taskBto);
        return ResultUtil.success(task.parse2Bto().toVo());
    }

    @ApiOperation(value = "是否已读设置", notes = "可以通过这个接口设置业务的是否已读")
    @PostMapping("/setRead")
    public ResponseEntity setRead(@RequestBody @Validated TaskTopVo taskTopVo) {
        TaskBto taskBto = taskService.get(taskTopVo.getTaskId());
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = taskBto.getUserReadDetailList();
        if (taskTopVo.getTopFlag() == 1) {
            if (userIds != null) {
                taskBto.getUserReadDetailList().add(userId);
            }
        }
        if (taskTopVo.getTopFlag() == 0) {
            if (userIds != null && userIds.contains(userId)) {
                userIds.removeAll(new ArrayList<>(Collections.singletonList(userId)));
            }
        }
        Task task = taskService.update(taskBto);
        return ResultUtil.success(task.parse2Bto().toVo());
    }

    @ApiOperation(value = "查询业务日志", notes = "可以通过这个接口查询查询业务日志")
    @GetMapping("/manage/detail/log/{id}")//业务履历
    public ResponseEntity selectLog(@PathVariable("id") int taskId) {
        //添加当前业务日志
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId(taskId);
        //查询所有子业务
//        List<TaskBto> taskBtos = taskDao.findAll().stream()
//                .filter(task -> task.getNodeIdDetail() != null && task.getNodeIdDetail().contains("." + taskId + "."))
//                .map(Task::parse2Bto)
//                .collect(Collectors.toList());
//        //添加子业务日志
//        if (taskBtos.size() > 0) {
//            taskBtos.forEach(taskBto -> taskLogUserVos.addAll(taskLogService.getByTaskId(taskBto.getId())));
//        }
        //按日志时间排序
        List<TaskLogUserVo> taskLogUserVoList = taskLogUserVos.stream()
                .sorted(Comparator.comparing(TaskLogUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)).reversed())
                .collect(Collectors.toList());
        return ResultUtil.success(taskLogUserVoList);
    }

    @ApiOperation(value = "根据bill查询业务日志", notes = "可以通过这个接口查询查询业务日志")
    @GetMapping("/manage/detail/log/bill/{id}")
    public ResponseEntity selectBillLog(@PathVariable("id") int bill) {

       Task taskEn= taskDao.findByBillIdAndBusinessType(bill, BusinessEnum.CONFIRM_CHECK_STAT.id).get();

        //添加当前业务日志
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId(taskEn.getId());
        //查询所有子业务
        List<TaskBto> taskBtos = taskDao.findAll().stream()
                .filter(task -> task.getNodeIdDetail() != null && task.getNodeIdDetail().contains("." + taskEn.getId() + "."))
                .map(Task::parse2Bto)
                .collect(Collectors.toList());
        //添加子业务日志
        if (taskBtos.size() > 0) {
            taskBtos.forEach(taskBto -> taskLogUserVos.addAll(taskLogService.getByTaskId(taskBto.getId())));
        }
        //按日志时间排序
        List<TaskLogUserVo> taskLogUserVoList = taskLogUserVos.stream()
                .sorted(Comparator.comparing(TaskLogUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)).reversed())
                .collect(Collectors.toList());
        return ResultUtil.success(taskLogUserVoList);
    }

    @ApiOperation(value = "核查详情查询业务日志", notes = "可以通过这个接口查询查询业务日志")
    @GetMapping("/manage/detail/log/bill/details/{id}")
    public ResponseEntity selectBillLog7(@PathVariable("id") int bill) {

        Task taskEn= taskDao.findByBillIdAndBusinessType(bill, BusinessEnum.CONFIRM_CHECK_DETAIL.id).get();

        //添加当前业务日志
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId(taskEn.getId());
        //查询所有子业务
        List<TaskBto> taskBtos = taskDao.findAll().stream()
                .filter(task -> task.getNodeIdDetail() != null && task.getNodeIdDetail().contains("." + taskEn.getId() + "."))
                .map(Task::parse2Bto)
                .collect(Collectors.toList());
        //添加子业务日志
        if (taskBtos.size() > 0) {
            taskBtos.forEach(taskBto -> taskLogUserVos.addAll(taskLogService.getByTaskId(taskBto.getId())));
        }
        //按日志时间排序
        List<TaskLogUserVo> taskLogUserVoList = taskLogUserVos.stream()
                .sorted(Comparator.comparing(TaskLogUserVo::getCreateTime,Comparator.nullsLast(Date::compareTo)).reversed())
                .collect(Collectors.toList());
        return ResultUtil.success(taskLogUserVoList);
    }

    @ApiOperation(value = "查询所有业务日志", notes = "可以通过这个接口查询业务日志")
    @PostMapping("/manage/detail/logs")
    public ResponseEntity selectAllLogs(@RequestBody TaskLogSelectVo taskLogSelectVo){
        return ResponseEntity.ok( PageUtil.getPerPage(taskLogSelectVo.getPage(), taskLogSelectVo.getSize(), taskLogService.getAllByTime(taskLogSelectVo), taskLogSelectVo.getPageable()));
    }

    @ApiOperation(value = "任务对象", notes = "根据任务id查询任务对象")
    @GetMapping("/task/id")
    public ResponseEntity getTask(Integer taskId){
        return ResponseEntity.ok(taskService.findByTaskId(taskId).toVo());
    }

    @ApiOperation(value = "任务日志", notes = "根据任务id查询任务日志")
    @PostMapping("/taskLog/taskBusinessTypeVo")
    public ResponseEntity getTaskLog(@RequestBody TaskBusinessTypeVo taskBusinessTypeVo){

        Integer businessType = taskBusinessTypeVo.getBusinessType();
        Integer taskId = taskBusinessTypeVo.getTaskId();
        //拿到标志位
//        Integer outOrEnter = taskBusinessTypeVo.getOutOrEnter();
        //当前状态
        Integer billStatus = taskService.get(taskId).getBillStatus();
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId2(taskId);

//        List<TaskBto> taskBtos = taskDao.findAll().stream()
//                .filter(task -> task.getNodeIdDetail() != null && task.getNodeIdDetail().contains("." + taskId + "."))
//                .map(Task::parse2Bto)
//                .collect(Collectors.toList());
//        if (taskBtos.size() > 0) {
//            taskBtos.forEach(taskBto -> taskLogUserVos.addAll(taskLogService.getByTaskId(taskBto.getId())));
//        }
        switch(businessType){
            case 3 :
               return ResponseEntity.ok(allot2(taskLogUserVos,billStatus));

            case 22 :
                //语句
                return ResponseEntity.ok(backAllot2(taskLogUserVos,billStatus));
            case 10 :
                //语句
                return ResponseEntity.ok(repairBack2(taskLogUserVos,billStatus));
            case 5 :
                //语句
                return ResponseEntity.ok(repair2(taskLogUserVos,billStatus));
            case 17:
                return ResponseEntity.ok(destructionAndScrap(taskLogUserVos,billStatus));
            case 14:
                return ResponseEntity.ok(destructionAndScrap(taskLogUserVos,billStatus));
            case 23:
                return ResponseEntity.ok(destructionAndScrap(taskLogUserVos,billStatus));
            case 16:
                return ResponseEntity.ok(sendBack(taskLogUserVos,billStatus));
            default : //可选
                return ResponseEntity.ok(defaults(taskLogUserVos));
        }

    }

    /**
     * 退役、报废、销毁 流程图操作人显示数据查询接口
     * 特殊例子 判断当前任务状态是否为草稿 1250、2223、8110
     */
    private Map<String,String>  destructionAndScrap(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        if (billStatus==1250 ||billStatus==2223|| billStatus==8110){
            return map;
        }else {
          map= defaults(taskLogUserVos);
          if (billStatus==1251 || billStatus==2224){
              map.remove("1251");
              map.remove("2224");
          }
        return map;
        }

    }


    private Map<String,String>  sendBack(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        map=defaults(taskLogUserVos);
        map.remove("0");
        if (billStatus==1208){
            map.remove("1208");
            map.remove("1217");
        }else if(billStatus==1217){
            map.remove("1217");
        }else if (billStatus==1209){
            map.remove("1209");
            map.remove("1220");

//            map.remove("1217");
        }else if (billStatus==1220){
            map.remove("1220");
        }else if (billStatus == 1215 && !map.containsKey("1218")){
            map.remove("1220");
        }
        if (!map.containsKey("1219") && billStatus!=1219){
            map.remove("1217");
        }
        return map;

    }


//    private Map<String, String> allot(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
//        Map<String, String> map = new HashMap<>();
//        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
//            if (taskLogUserVo.getOldStatus()!=null){
//
//                if (taskLogUserVo.getOldStatus() == 340){
//                    if (map.containsKey("340")){
//                        if (billStatus == 302 || billStatus == 340){
//                            map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                        } else {
//                            if (billStatus == 341 && !map.containsKey("302")){
//                                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                            }else {
//                                map.put("340j",taskLogUserVo.getUser());
//                            }
//                        }
//
//                    }else {
//                        //存在 配发中
//                        if (map.containsKey("302")){
//                            map.put("340j",taskLogUserVo.getUser());
//                        }else {
//                            if (billStatus == 333 && taskLogUserVo.getOldStatus() == 340){
//                                map.clear();
//                            }else {
//                                map.put("340",taskLogUserVo.getUser());
//                            }
//                        }
//                        if (billStatus == 302 && map.containsKey("340j")){
//                            map.remove("340j");
//                        }
//                        if (!map.containsKey("341")){
//                            map.remove("340");
//                        }
//
//                    }
//                } else {
//                    //0 333
//                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                    if (billStatus == 302 && map.containsKey("340")){
//                        map.remove("340");
//                        map.remove("341");
//                    }
//
//                    //签章拒绝 改为签字 需要移除340 340j
//                    if (billStatus == 303 && taskLogUserVo.getOldStatus() == 302){
////                        map.remove("340");
//                        map.remove("340j");
////                        map.remove("341");
//                    }
//
//                    if (billStatus == 333 && map.containsKey("340")){
//                        map.remove("340");
//                    }
//
//                    if (billStatus == 340 && map.containsKey("340") && !map.containsKey("302") && taskLogUserVo.getOldStatus()!=341){
//                        map.remove("340");
//
//                    }
//                    //add
//                    if (billStatus == 340 && taskLogUserVo.getOldStatus() == 302){
//                        map.remove("340j");
//                        map.remove("340");
//                        map.remove("341");
//                    }
//                }
//
//            }
//
//        }
//        return map;
//
//    }


    private Map<String, String> allot2(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
            if (taskLogUserVo.getOldStatus()!=null){
                if (taskLogUserVo.getOldStatus() == 340){
                    if (map.containsKey("340")){
                        if (map.containsKey("302")) {
                            map.put("340j", taskLogUserVo.getUser());
                        }else {
                            map.put("340",taskLogUserVo.getUser());
                        }
                    } else {
                        if (map.containsKey("302")) {
                            map.put("340j", taskLogUserVo.getUser());
                        }else {
                            map.put(taskLogUserVo.getOldStatus() + "", taskLogUserVo.getUser());
                        }
                    }
                    }else {
                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
                }
                }else {
                     map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
                }
            }
        if (billStatus==333){
            map.remove("340");
        }
        if (billStatus==340 && !map.containsKey("302")){
            map.remove("340");
        }
        if (!map.containsKey("341") && billStatus!=341){
            map.remove("340");
        }
        if (billStatus==341 && map.containsKey("302")){
            map.remove("340");
        }
        if (billStatus==302||billStatus==340){
            map.remove("340j");
        }
        if (!map.containsKey("341") && billStatus!=341&&map.containsKey("302")){
            map.remove("340j");
        }
        return map;

    }

    private Map<String, String> backAllot2(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
            if (taskLogUserVo.getOldStatus()!=null){
                if (taskLogUserVo.getOldStatus() == 930){
                    if (map.containsKey("930")){
                        if (map.containsKey("900")) {
                            map.put("930j", taskLogUserVo.getUser());
                        }else {
                            map.put("930",taskLogUserVo.getUser());
                        }
                    } else {
                        if (map.containsKey("900")) {
                            map.put("930j", taskLogUserVo.getUser());
                        }else {
                            map.put(taskLogUserVo.getOldStatus() + "", taskLogUserVo.getUser());
                        }
                    }
                }else {
                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
                }
            }else {
                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
            }
        }
        if (billStatus==922){
            map.remove("930");
        }
        if (billStatus==930 && !map.containsKey("900")){
            map.remove("930");
        }
        if (!map.containsKey("931") && billStatus!=931){
            map.remove("930");
        }
        if (billStatus==931 && map.containsKey("900")){
            map.remove("930");
        }
        if (billStatus==900||billStatus==930){
            map.remove("930j");
        }
        if (!map.containsKey("931") && billStatus!=931&&map.containsKey("900")){
            map.remove("930j");
        }
        return map;

    }

//    private Map<String, String> backAllot(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
//        Map<String, String> map = new HashMap<>();
//        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
//            if (taskLogUserVo.getOldStatus()!=null){
//
//                if (taskLogUserVo.getOldStatus() == 930){
//                    if (map.containsKey("930")){
//                        if (billStatus == 900 || billStatus == 930){
//                            map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                        } else {
//                            if (billStatus == 931 && !map.containsKey("900")){
//                                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                            }else {
//                                map.put("930j",taskLogUserVo.getUser());
//                            }
//
//                        }
//                    }else {
//                        //存在 配发中
//                        if (map.containsKey("900")){
//                            map.put("930j",taskLogUserVo.getUser());
//                        }else {
//                            if (billStatus == 922 && taskLogUserVo.getOldStatus() == 930){
//                                map.clear();
//                            }else {
//                                map.put("930",taskLogUserVo.getUser());
//                            }
//                        }
//                        if (billStatus == 900 && map.containsKey("930j")){
//                            map.remove("930j");
//                        }
//                        if (!map.containsKey("931")){
//                            map.remove("930");
//                        }
//
//                    }
//                } else {
//                    //0 333
//                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//
//                    if (billStatus == 900 && map.containsKey("930")){
//                        map.remove("930");
//                        map.remove("931");
//                    }
//                    if (billStatus == 922 && map.containsKey("930")){
//                        map.remove("930");
//                    }
//
//                    if (billStatus == 930 && map.containsKey("930") && !map.containsKey("900") && taskLogUserVo.getOldStatus()!=931){
//                        map.remove("930");
//                    }
//
//                    //签章拒绝 改为签字 需要移除340 340j
//                    if (billStatus == 901 && taskLogUserVo.getOldStatus() == 900){
//                        map.remove("930");
//                        map.remove("930j");
//                    }
//
//                    //add
//                    if (billStatus == 930 && taskLogUserVo.getOldStatus() == 900){
//                        map.remove("930j");
//                        map.remove("931");
//                        map.remove("930");
//                    }
//                }
//
//            }
//
//        }
//        return map;
//
//    }

    private Map<String, String> repair2(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
            if (taskLogUserVo.getOldStatus()!=null){
                if (taskLogUserVo.getOldStatus() == 790){
                    if (map.containsKey("790")){
                        if (map.containsKey("701")) {
                            map.put("790j", taskLogUserVo.getUser());
                        }else {
                            map.put("790",taskLogUserVo.getUser());
                        }
                    } else {
                        if (map.containsKey("701")) {
                            map.put("790j", taskLogUserVo.getUser());
                        }else {
                            map.put(taskLogUserVo.getOldStatus() + "", taskLogUserVo.getUser());
                        }
                    }
                }else {
                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
                }
            }else {
                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
            }
        }
        if (billStatus==788){
            map.remove("790");
        }
        if (billStatus==790 && !map.containsKey("701")){
            map.remove("790");
        }
        if (!map.containsKey("791") && billStatus!=791){
            map.remove("790");
        }
        if (billStatus==791 && map.containsKey("701")){
            map.remove("790");
        }
        if (billStatus==701||billStatus==790){
            map.remove("790j");
        }
        if (!map.containsKey("791") && billStatus!=791 && map.containsKey("701")){
            map.remove("790j");
        }
        return map;

    }
//    private Map<String, String> repair(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
//
//        Map<String, String> map = new HashMap<>();
//        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
//            if (taskLogUserVo.getOldStatus()!=null){
//
//                if (taskLogUserVo.getOldStatus() == 790){
//                    if (map.containsKey("790")){
//                        if (billStatus == 701 || billStatus == 790){
//                            map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                        } else {
//                            if (billStatus == 791 && !map.containsKey("701")){
//                                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                            }else {
//                                map.put("790j",taskLogUserVo.getUser());
//                            }
//                        }
//                    }else {
//                        //存在 配发中
//                        if (map.containsKey("701")){
//                            map.put("790j",taskLogUserVo.getUser());
//                        }else {
//                            if (billStatus == 788 && taskLogUserVo.getOldStatus() == 790){
//                                map.clear();
//                            }else {
//                                map.put("790",taskLogUserVo.getUser());
//                            }
//                        }
//                        if (billStatus == 701 && map.containsKey("790j")){
//                            map.remove("790j");
//                        }
//                        if (!map.containsKey("791")){
//                            map.remove("790");
//                        }
//                    }
//                } else {
//                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                    if (billStatus == 701 && map.containsKey("790")){
//                        map.remove("790");
//                        map.remove("791");
//                    }
//                    //0 333
//
//                    if (billStatus == 788 && map.containsKey("790")){
//                        map.remove("790");
//                    }
//
//                    if (billStatus == 790 && map.containsKey("790") && !map.containsKey("701") && taskLogUserVo.getOldStatus()!=791){
//                        map.remove("790");
//                    }
//                    //签章拒绝 改为签字 需要移除340 340j
//                    if (billStatus == 704 && taskLogUserVo.getOldStatus() == 701){
//                        map.remove("790");
//                        map.remove("790j");
//                    }
//                    //add
//                    if (billStatus == 790 && taskLogUserVo.getOldStatus() == 701){
//                        map.remove("790j");
//                        map.remove("790");
//                        map.remove("791");
//                    }
//                }
//
//            }
//
//
//        }
//        return map;
//
//    }

    private Map<String, String> repairBack2(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
        Map<String, String> map = new HashMap<>();
        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
            if (taskLogUserVo.getOldStatus()!=null){
                if (taskLogUserVo.getOldStatus() == 820){
                    if (map.containsKey("820")){
                        if (map.containsKey("801")) {
                            map.put("820j", taskLogUserVo.getUser());
                        }else {
                            map.put("820",taskLogUserVo.getUser());
                        }
                    } else {
                        if (map.containsKey("801")) {
                            map.put("820j", taskLogUserVo.getUser());
                        }else {
                            map.put(taskLogUserVo.getOldStatus() + "", taskLogUserVo.getUser());
                        }
                    }
                }else {
                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
                }
            }else {
                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
            }
        }
        if (billStatus==804){
            map.remove("820");
        }
        if (billStatus==820 && !map.containsKey("801")){
            map.remove("820");
        }
        if (!map.containsKey("821") && billStatus!=821){
            map.remove("820");
        }
        if (billStatus==821 && map.containsKey("801")){
            map.remove("820");
        }
        if (billStatus==801||billStatus==820){
            map.remove("820j");
        }
        if (!map.containsKey("821") && billStatus!=821&&map.containsKey("801")){
            map.remove("820j");
        }
        return map;

    }
//    private Map<String, String> repairBack(List<TaskLogUserVo> taskLogUserVos,Integer billStatus){
//        Map<String, String> map = new HashMap<>();
//        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
//            if (taskLogUserVo.getOldStatus()!=null){
//
//                if (taskLogUserVo.getOldStatus() == 820){
//                    if (map.containsKey("820")){
//                        if (billStatus == 801 || billStatus == 820){
//                            map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                        } else {
//                            if (billStatus == 821 && !map.containsKey("801")){
//                                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//                            }else {
//                                map.put("820j",taskLogUserVo.getUser());
//                            }
//                        }
//                    }else {
//                        //存在 配发中
//                        if (map.containsKey("801")){
//                            map.put("820j",taskLogUserVo.getUser());
//                        }else {
//                            if (billStatus == 888 && taskLogUserVo.getOldStatus() == 820){
//                                map.clear();
//                            }else {
//                                map.put("820",taskLogUserVo.getUser());
//                            }
//                        }
//                        if (billStatus == 801 && map.containsKey("820j")){
//                            map.remove("820j");
//                        }
//                    }
//                } else {
//                    map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
//
//                    if (billStatus == 801 && map.containsKey("820")){
//                        map.remove("820");
//                        map.remove("821");
//                    }
//                    //0 333
//                    if (billStatus == 888 && map.containsKey("820")){
//                        map.remove("820");
//                    }
//
//                    if (billStatus == 820 && map.containsKey("820") && !map.containsKey("801") && taskLogUserVo.getOldStatus()!=821){
//                        map.remove("820");
//                    }
//                    //签章拒绝 改为签字 需要移除340 340j
//                    if (billStatus == 804 && taskLogUserVo.getOldStatus() == 801){
//                        map.remove("820");
//                        map.remove("820j");
//                    }
//                    //add
//                    if (billStatus == 820 && taskLogUserVo.getOldStatus() == 801){
//                        map.remove("820j");
//                        map.remove("820");
//                        map.remove("821");
//                    }
//                }
//
//            }
//
//        }
//        return map;
//
//    }

    private Map<String, String>  defaults(List<TaskLogUserVo> taskLogUserVos){
        Map<String, String> map = new HashMap<>();
        for (TaskLogUserVo taskLogUserVo : taskLogUserVos) {
            if (taskLogUserVo.getOldStatus()!=null){
                map.put(taskLogUserVo.getOldStatus()+"",taskLogUserVo.getUser());
            }
        }
        return map;
    }


}
