package com.tykj.dev.device.task.service;


import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.vo.TaskLogSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface TaskLogService {
    /**
     * @param taskLogBto 日志bto
     * @return 添加日志接口
     */
    void addLog(TaskLogBto taskLogBto);

//    void sendHash(TaskLog taskLog);

    TaskLogBto getOne(Integer id);

    /**
     * @param taskId 业务id
     *               获取业务日志
     */
    List<TaskLogUserVo> getByTaskId(Integer taskId);

    /**
     * @param taskId 业务id
     *               获取业务日志 按照时间升序排列
     */
    List<TaskLogUserVo> getByTaskId2(Integer taskId);

    /**
     * @param taskLogSelectVo 查询vo
     * 获取所有业务操作日志
     */
    List<TaskLogUserVo> getAllByTime(TaskLogSelectVo taskLogSelectVo);
}
