package com.tykj.dev.device.task.service;

import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.misc.base.StatusEnum;

import java.util.List;
import java.util.Optional;

/**
 * @author dengdiyi
 */
public interface TaskService {

    /**
     * 逻辑删除任务对象
     * @param task 修改逻辑字段为1的任务对象
     * @return 修改的后的任务对象
     */
    Task deleteById(Task task);

    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     */
    TaskBto moveToNext(TaskBto taskBto);

    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     *
     * @param customInfo 自定义信息
     */
    TaskBto moveToNext(TaskBto taskBto, String customInfo);

    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     *
     * @param userId 待办用户Id
     */
    TaskBto moveToNext(TaskBto taskBto, Integer userId);

    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     *
     * @param userId     待办用户Id
     * @param customInfo 自定义信息
     */
    TaskBto moveToNext(TaskBto taskBto, Integer userId, String customInfo);

    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     *
     * @param statusEnum 状态枚举
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum);

    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     *
     * @param statusEnum 状态枚举
     * @param customInfo 自定义信息
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, String customInfo);

    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     *
     * @param statusEnum 状态枚举
     * @param userId     待办用户Id
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId);


    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     *
     * @param statusEnum 状态枚举
     * @param userId     待办用户Id
     * @param customInfo 自定义信息
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId, String customInfo);

    /**
     * 业务完结
     */
    TaskBto moveToEnd(TaskBto taskBto);

    /**
     * 业务审核失败封存
     */
    TaskBto moveToArchive(TaskBto taskBto);

    /**
     * 业务撤回
     */
    TaskBto moveToRevoke(TaskBto taskBto);

    /**
     * 新增Task
     */
    TaskBto start(TaskBto taskBto);

    /**
     * @param taskBtos 异步上链
     */
    void sendHash(List<TaskBto> taskBtos);

    /**
     * @param taskBto 异步上链
     */
    void sendHash(TaskBto taskBto);

    /**
     * 更新Task
     */
    Task update(TaskBto taskBto);

    /**
     * 根据task id获得Task
     */
    TaskBto get(Integer taskId);

    /**
     * 根据billId和businessType获得Task
     */
    TaskBto get(Integer billId, Integer businessType);


    /**
     * 根据billId和businessType获得Task
     */
    TaskBto getParentTaskIsNull(Integer billId, Integer businessType);
    TaskBto getParentTaskIsNotNull(Integer billId, Integer businessType);

    /**
     * @param taskSelectVo 获取跟踪和待办业务列表
     */
    List<TaskUserVo> getList(TaskSelectVo taskSelectVo);

    /**
     * @param taskSelectVo 获取业务管理中的业务列表
     */
    List<TaskUserVo> getManageList(TaskSelectVo taskSelectVo);

    List<TaskUserVo> getManageList1(TaskSelectVo taskSelectVo);

    /**
     * @param taskBto 任务bto
     * @param userId  新增涉及用户id
     *                不指定用户的任务被用户接取之后新增涉及用户
     */
    TaskBto addInvolveUser(TaskBto taskBto, Integer userId);

    /**
     * 判断该根任务节点下的所有task是否都处于完结状态
     *
     * @param rootId task的根节点id
     * @return Task Tree 是否已经结束
     */
    boolean TaskTreeIsOver(int rootId);

    /**
     * 判断该任务节点下的所有节点是否任意一个都没有处于完结状态(即用来判断该任务树是否是初始状态)
     * @param rootId  task的根节点id
     * @param currentIsOver 当前的child节点是否处于完结状态
     * @return Task Tree 是否是初始状态
     */
    boolean TaskTreeIsStart(int rootId,boolean currentIsOver);



    /**
     * @param oldUserId 旧专管员id
     * @param newUserId 新交接专管员id
     *                  工作交接替换跟踪和待办
     */
    void workHandover(Integer oldUserId, Integer newUserId);

    /**
     * 根据业务id 以及 业务类型进行查询
     */
    List<TaskBto> findBillIdAndBillType(List<Integer> billIds,Integer billType);


    /**
     * 根据业务id 以及 业务类型以及不为8888的业务状态 进行查询
     */
    Optional<Task> findBillIdAndBusinessType(Integer billId, Integer businessType,Integer billStatus);




    /**
     * 根据业务id 以及 业务类型进行查询
     */
    Optional<Task> findBillIdAndBusinessTypeNotBillStatus(Integer billId, Integer businessType);

    /**
     * 根据父id查询customInfo为shi的task
     */
    TaskBto findFatherIdAndCustomInfo(Integer taskId);

    /**
     * 根据billType 查询task集合
     */
    List<TaskBto> findBillType(Integer billType);


    TaskBto findByBillIdAndBusinessTypeIsNotCustomInfo(Integer billId,Integer businessType);

    /**
     * @param taaskId 父Task ID
     * 将父Task所有子Task办结
     */
    void moveAllSonNodeToEnd(Integer taaskId);

    /**
     * 根据上级id以及billType 查询task
     */
    TaskBto findBillTypeAndFatherId(Integer billType,Integer fatherId);

    List<TaskBto> findAllBillTypeAndFatherId(Integer billType,Integer fatherId);

    /**
     *  根据业务类型和父类id集合查询任务
     * @param billType 业务类型
     * @param fatherIds 父类id集合
     * @return 任务集合
     */
    List<TaskBto> findAllBillTypeAndFatherIdIn(Integer billType,List<Integer> fatherIds);

    TaskBto findByTaskId(Integer taskId);

    List<TaskBto> findAllByBillIdAndBusinessType2(Integer billId,Integer businessType);

    List<Task> findAllByBillAndBusinessTypeAndOwnUnit(Integer businessType,Integer ownUnit);

    /**
     * 查询多个任务
     */
    TaskBto findByTaskIds(List<Integer> ids);

    /**
     * 根据billId和businessType获得Task
     */
    List<Task> findByBillIdAndBusinessType(Integer billId, Integer businessType);
}
