package com.tykj.dev.device.task.subject.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("待办任务查询类")
public class TaskSelectVo extends CustomPage {
    @ApiModelProperty(value = "模糊查询关键字", example = "测试")
    public String content;
    @ApiModelProperty(value = "发起时间", example = "2020-10-10 01:10:10")
    public Date startTime;
    @ApiModelProperty(value = "结束时间", example = "2020-10-10 01:10:10")
    public Date endTime;
    @ApiModelProperty(value = "查询方式(0:全部业务,1:我的发起,2:待办业务,3:业务跟踪,4:办结任务,5:封存业务)", example = "0")
    private Integer selectNum;
    @ApiModelProperty(value = "业务类型id", example = "1")
    private List<Integer> businessType;
    @ApiModelProperty(value = "待办类型(1:省内待办，2：省外待办)", example = "1")
    private Integer type;
    @ApiModelProperty(value = "业务状态", example = "1")
    private Integer billStatus;
    @ApiModelProperty(value = "业务备注", example = "测试")
    public List<String> remark;

    @ApiModelProperty(value = "标题模糊查询字段")
    private String titleDim;

    @ApiModelProperty(value = "状态模糊查询字段")
    private String statusDim;

    @ApiModelProperty(value = "发起人模糊查询字段")
    private String createUserDim;

    @ApiModelProperty(value = "待办人模糊查询字段")
    private String processingUserDim;

}
