package com.tykj.dev.device.train.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.train.entity.vo.*;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainTheme.java
 * @Description 新增培训对象
 * @createTime 2020年08月11日 21:35:00
 */
@ApiModel("新增培训对象")
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Data
@Entity
public class TrainTheme {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "培训id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "报名截止时间")
    private Date trainTime;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String originatorName;

    /**
     * 发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;

    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;


    @Column(name = "train_data_files" ,columnDefinition = "TEXT")
    @ApiModelProperty(value = "培训资料文件db", name = "trainDataFiles")
    private String trainDataFiles;


    @ApiModelProperty(value = "培训资料文件集合")
    @Transient
    private List<FileRet> trainDataFileList = new ArrayList<>();

    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis")
    private String trainSynopsis;

    /**
     * 培训结果
     */
    private String trainingResults;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态")
    private Integer trainStatus;

    /**
     * 发证状态
     */
    @ApiModelProperty(value = "发证状态", name = "isCertificate")
    private Integer isCertificate;

    /**
     * 及格
     */
    @ApiModelProperty(value = "及格", name = "pass")
    private Integer pass;

    /**
     * 优秀
     */
    @ApiModelProperty(value = "优秀", name = "good")
    private Integer good;

    /**
     * 创建用户id
     */
    @CreatedBy
    private Integer createUserId;

    /**
     * 更新用户id
     */
    @LastModifiedBy
    private Integer updateUserId;

    /**
     * 创建时间
     */
    @CreatedDate
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @LastModifiedDate
    private LocalDateTime updateTime;

    /**
     * 培训类别 0.线上 1.线下
     */
    @ApiModelProperty(value = "培训类别", name = "trainType")
    private Integer trainType;

    /**
     * 考试时间限制
     */
    private Integer examinationTL;

    /**
     * 线上培训使用字段 是否批阅完成
     */
    private Integer isNotExamines=0;

    @Column(name = "generate_test_paper_string",columnDefinition = "TEXT")
    private String generateTestPaperString;

    @Transient
    private GenerateTestPaper generateTestPaper;

    /**
     * 删除标记(0:未删除，1:已删除)
     */
    private Integer deleteTag = 0;

    @Column(name = "courseware_files",columnDefinition = "TEXT")
    @ApiModelProperty(value = "课件DB", name = "trainPapersFiles")
    private String coursewareFiles;

    @ApiModelProperty(value = "课件集合")
    @Transient
    private List<CoursewareFile> coursewareFileList = new ArrayList<>();

    @Column(name = "train_papers_files",columnDefinition = "TEXT")
    @ApiModelProperty(value = "培训试卷文件db", name = "trainPapersFiles")
    private String trainPapersFiles;

    @ApiModelProperty(value = "培训试卷文件实体集合")
    @Transient
    private List<FileRet> trainPapersFileList = new ArrayList<>();

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    public ByTrainingPeople toByTrainingPeople() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, ByTrainingPeople.class);
    }

    public ByTrainingPeopleCheck toByTrainingPeopleCheck() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, ByTrainingPeopleCheck.class);
    }

    public TrainThemeVo toTrainThemeVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainThemeVo.class);
    }

    public TrainRegistrationVo toTrainRegistrationVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainRegistrationVo.class);
    }

    public TrainTrainingVo toTrainTrainingVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainTrainingVo.class);
    }

    public WaitExaminesVo toWaitExaminesVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, WaitExaminesVo.class);
    }


    public TrainAuditVo toTrainAuditVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainAuditVo.class);
    }

    public TrainDetailsVo toTrainDetailsVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, TrainDetailsVo.class);
    }


}
