package com.tykj.dev.device.train.entity.vo;

import com.tykj.dev.device.user.subject.entity.Mgrcert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Transient;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName GradeEntry.java
 * @Description 成绩录入类
 * @createTime 2020年08月15日 16:11:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "录入成绩对象", description = "录入成绩对象")
public class GradeEntry {
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "name")
    private String name;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private String unitsName;

    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;

    /**
     * 考勤
     */
    @ApiModelProperty(value = "考勤", name = "attendance")
    private String attendance;

    /**
     * 分数
     */
    @ApiModelProperty(value = "分数", name = "score")
    private String score;

    /**
     * 评价
     */
    @ApiModelProperty(value = "评价", name = "evaluation")
    private String evaluation;


    /**
     * 是否发证
     */
    @ApiModelProperty(value = "是否发证", name = "certificate")
    private Integer certificate;

    /**
     * 证书
     */
    @Transient
    private Mgrcert mgrcert;

    public Mgrcert toDo() {
//        LocalDateTime now = LocalDateTime.now().plusYears(2).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
//        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(formatStr);

//        String twoYearsFormat = now.format(dateTimeFormatter)
        LocalDate newDate=LocalDate.now();
        LocalDate plusYears1=newDate.plusYears(2);
        Date newDat = Date.from(newDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        Date plusYearsDate1 = Date.from(plusYears1.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());

        return new Mgrcert(null, name, userId, null, newDat, plusYearsDate1, 0, "培训证书");
    }
}
