package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName SignUpUsers.java
 * @Description TODO
 * @createTime 2020年12月11日 10:03:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "报名vo对象", description = "培训中返回的对象")
public class SignUpUsers {
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id",name ="userId")
    private Integer userId;


    @ApiModelProperty(value = "必须报名 不报名填写的备注",name = "node")
    private String note;

    @ApiModelProperty(value = "是否报名 0 报名 1否", name = "returns")
    private Integer returns;

    @ApiModelProperty(value = "到达时间", name = "arriveTime")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveTime;


    @ApiModelProperty(value = "离开时间", name = "leaveTime")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveTime;


    @ApiModelProperty(value = "到达就餐 1.午饭 2.晚饭", name = "arriveMeal")
    private Integer arriveMeal;


    @ApiModelProperty(value = "离开就餐 1.午饭 2.晚饭", name = "leaveMeal")
    private Integer leaveMeal;


}
