package com.tykj.dev.device.train.service;

import com.tykj.dev.device.train.entity.GenerateTestPaper;
import com.tykj.dev.device.train.entity.TestPaper;
import com.tykj.dev.device.train.entity.vo.TestPaperListVo;
import com.tykj.dev.device.train.entity.vo.TestPaperManagementListVo;

import java.util.List;

public interface TestPaperService {
    /**
     * 添加试卷
     */
    TestPaper saveProble(TestPaper testPaper);



    /**
     * 根据id查询试卷
     */
    TestPaper findByIdProble(Integer id);

    /**
     * 根据id查询试卷
     */
    TestPaper findByUserIdAndTrainId(Integer userId,Integer trainId);


    /**
     * 根据培训id以及状态查询试卷
     */
    List<TestPaper> findByTrainIdAndStatus(Integer trainId,Integer status);


    /**
     * 查询所有试卷
     */
    List<TestPaper> findAll();

    /**
     * 根据id删除试卷
     */
    void deleteById(Integer id);

    /**
     * 生成试卷
     */
    TestPaper generateTestPaper(GenerateTestPaper generateTestPaper);


    List<TestPaperManagementListVo> TEST_PAPER_MANAGEMENT_LIST_VOS(Integer unitId,Integer status);


    List<TestPaperListVo> findAllByTrainId(Integer trainId);

//    Page<TestPaper> pageTestPaperSelect(TestPaperPageVo TestPaperPageVo);
}
