package com.tykj.dev.device.train.service;

import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.device.train.entity.TrainUser;
import com.tykj.dev.device.train.entity.vo.*;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainService.java
 * @Description TODO
 * @createTime 2020年08月13日 15:21:00
 */
public interface TrainThemeService {

    TrainTheme save(TrainTheme trainTheme);

    /**
     * @param trainThemes 异步上链
     */
    void sendHash(List<TrainTheme> trainThemes);

    TrainTheme findById(Integer trainThemeId);

    List<TrainTheme> findAllStatus(Integer status);

    ByTrainingPeople findByTrainingPeople(Integer trainThemeId, Integer userId);

    ByTrainingPeopleCheck findByTrainingPeopleCheck(Integer trainThemeId, Integer userId);

    TrainRegistrationVo findRegistrationVo(Integer trainThemeId);

    TrainTrainingVo findTrainTrainingVo(Integer trainThemeId);

    TrainAuditVo findTrainAuditVo(Integer trainThemeId);

    TrainTheme updateTrain(TrainUpdateVo trainUpdateVo);

    TrainThemePage findTrainPageVo(ConditionsTrainVo conditionsTrainVo);

    TrainDetailsVo findSelectDetailsVo(Integer trainId);

    TrainTheme findBytaskId(Integer taskId);

    List<TrainUser> findAllTrainUserByTrainId(Integer trainId);

    List<TrainTheme> findByUnitIdAndisNotExamines(Integer isNotExamines,Integer unitId);


    WaitExaminesVo findWaitExaminesVo(Integer trainId);
}
