package com.tykj.dev.device.user.base.req;

import com.tykj.dev.device.user.subject.entity.DeductionItem;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeductionItemAddVo.java
 * @Description TODO
 * @createTime 2021年08月11日 11:33:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "添加扣分项实体", description = "添加扣分项实体")
public class DeductionItemAddVo {
    @ApiModelProperty(value = "扣分描述", name = "des", example = "12321L")
    private String des;

    @ApiModelProperty(value = "相关人员",name = "relatedUser")
    private List<Integer> relatedUserIds;

    @ApiModelProperty(value = "业务类型",name = "billType")
    private Integer billType;

    @ApiModelProperty(value = "任务id",name = "taskId")
    private Integer taskId;

    public DeductionItem toDb(){
        ModelMapper mapper = BeanHelper.getUserMapper();
        DeductionItem deductionItem=  mapper.map(this, DeductionItem.class);
        deductionItem.setRelatedUser(JacksonUtil.toJSon(relatedUserIds));
        return deductionItem;
    }

}
