package com.tykj.dev.device.user.base.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName VenitalisVo.java
 * @Description TODO
 * @createTime 2020年11月17日 13:21:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "注册指静脉接口", description = "注册指静脉接口参数信息")
public class VenitalisVo {
    /**
     * 注册指静脉的用户id
     */
    @ApiModelProperty(value = "注册指静脉的用户id", name = "userId", example = "12321L")
    private Integer userId;

    /**
     * 指静脉仪器的序列号
     */
    @ApiModelProperty(value = "指静脉仪器的序列号", name = "deviceType", example = "12321L")
    private String  deviceType;

    /**
     * 采集到的特征值
     */
    @ApiModelProperty(value = "采集到的特征值", name = "value", example = "12321L")
    private List<String>  value;
}
