package com.tykj.dev.device.user.read.controller;

/**
 * @author dengdiyi
 */

import com.tykj.dev.config.GlobalMap;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.ret.BusinessTypeVo;
import com.tykj.dev.device.user.base.ret.MessageSelectVo;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.vo.MessageUserVo;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.*;
import java.util.stream.Collectors;

//import com.tykj.dev.device.read.service.MessageService;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "阅知模块", description = "阅知模块")
@AutoDocument
@RequestMapping("/read")
public class MessageController {

    @Autowired
    private MessageService messageService;

    @Autowired
    private MyWebSocket myWebSocket;

    @ApiOperation(value = "未读阅知信息查询")
    @GetMapping("/get")
    public ResponseEntity getMessage(){
        return ResponseEntity.ok(messageService.getList());
    }

    @ApiOperation(value = "新增阅知信息查询")
    @GetMapping("/getNew")
    public ResponseEntity getNewMessage(){
        return ResponseEntity.ok(messageService.getNewList());
    }

    @ApiOperation(value = "所有阅知信息查询")
    @PostMapping("/get/all")
    public ResponseEntity getAllMessage(@RequestBody MessageSelectVo messageSelectVo){
        Boolean hasContentDim = messageSelectVo.getContentDim()!=null;
        Boolean hasOperatorDim = messageSelectVo.getOperatorDim()!=null;
        List<MessageUserVo> messageUserVos = messageService.getAllList(messageSelectVo);
//        messageUserVos.sort(Comparator.comparing(MessageUserVo::getIsTop).reversed().thenComparing(MessageUserVo::getCreateTime).reversed());
        //模糊查询筛选
        if (hasContentDim||hasOperatorDim) {
            messageUserVos = messageUserVos.stream().filter(messageUserVo -> {
                Boolean containContentDim = !hasContentDim||messageUserVo.getContent().contains(messageSelectVo.getContentDim());
                Boolean containOperatorDim = !hasOperatorDim||messageUserVo.getOperator().contains(messageSelectVo.getOperatorDim());
                return containContentDim&&containOperatorDim;
            }).collect(Collectors.toList());
        }
        //分页
        Page<MessageUserVo> taskUserVos1 = PageUtil.getPerPage(messageSelectVo.getPage(), messageSelectVo.getSize(), messageUserVos, messageSelectVo.getPageable());
        //返回对象map
        Map<String,Object> map = new HashMap<>();
        Map<Integer,String> businessMap = GlobalMap.getBusinessMap();
        //存在的业务类型
        Set<Integer> businessType = messageUserVos.stream().map(MessageUserVo::getBusinessType).collect(Collectors.toSet());
        //分页数据
        map.put("pages",taskUserVos1);
        //存在的业务类型
        map.put("businessTypes",businessType.stream().map(integer -> new BusinessTypeVo(integer,businessMap.get(integer))).collect(Collectors.toList()));
        return ResponseEntity.ok(map);
    }

    @ApiOperation(value = "提交已读阅知信息")
    @PostMapping("/read/{id}")
    public ResponseEntity readMessage(@PathVariable("id") int id){
        MessageUserVo m = messageService.read(id).parse2Bto().toVo();
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(m);
    }

    @ApiOperation(value = "完成阅知信息")
    @PostMapping("/complete/{id}")
    public ResponseEntity completeMessage(@PathVariable("id") int id){
        return ResponseEntity.ok(messageService.complete(id).parse2Bto().toVo());
    }

    @ApiOperation(value = "判断是否存在阅知")
    @GetMapping("/isNotExistMessage")
    public ResponseEntity completeMessage(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        return ResponseEntity.ok(messageService.isNotExistMessage(securityUser.getCurrentUserInfo().getUserId()));
    }
}
