package com.tykj.dev.device.user.subject.dao;

import com.tykj.dev.device.user.subject.entity.Units;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface UnitsDao extends JpaRepository<Units, Integer>, JpaSpecificationExecutor<Units> {
    List<Units> findAllByLevel(Integer level);

    List<Units> findAllByAreaId(Integer areaId);

    Units findByName(String unitName);

    List<Units> findAllByLevelGreaterThanEqual(Integer level);

    List<Units> findAllByTypeNotIn(List<Integer> ids);

    List<Units> findAllByTypeNotInAndLevelIn(List<Integer> ids,List<Integer> levels);

    List<Units> findByAreaIdIn(List<Integer> areaIds);

    List<Units> findAllByAreaIdIn(List<Integer> ids);

    List<Units> findByAreaId(Integer area);

    List<Units> findByIdDel(Integer idDel);

    @Query("select o.areaId from Units o where o.name = ?1")
    int findAreaIdByName(String unitName);

    @Query("select o.areaId from Units o where o.unitId=?1")
    int findAreaId(int id);

    Units findTopByOrderByShowOrderDesc();

    Units findByAreaIdAndLevel(Integer areaId, Integer level);

    Units findByAreaIdEquals(Integer areaId);

    List<Units> findAllByLevelIn(List<Integer> levels);

    List<Units> findAllByType(Integer type);

}
