package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "用户待办阅知记录对象", description = "用户记录")
@SQLDelete(sql = "update user_record set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class UserRecord {

    @Id
    @GeneratedValue
    @ApiModelProperty(value = "id", name = "id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    @ApiModelProperty(value = "省以下待办任务id拼接", name = "taskIds")
    @Column(name = "task_ids",columnDefinition = "TEXT")
    private String taskIds;

    @ApiModelProperty(value = "新增省以下待办任务id拼接", name = "taskIds")
    @Column(name = "new_task_ids",columnDefinition = "TEXT")
    private String newTaskIds;

    @ApiModelProperty(value = "中央到省待办任务id拼接", name = "taskIds")
    @Column(name = "country_task_ids",columnDefinition = "TEXT")
    private String countryTaskIds;

    @ApiModelProperty(value = "新增中央到省待办任务id拼接", name = "taskIds")
    @Column(name = "new_country_task_ids",columnDefinition = "TEXT")
    private String newCountryTaskIds;

    @ApiModelProperty(value = "阅知任务id拼接", name = "readIds")
    @Column(name = "read_ids",columnDefinition = "TEXT")
    private String readIds;

    @ApiModelProperty(value = "新阅知任务id拼接", name = "readIds")
    @Column(name = "new_read_ids",columnDefinition = "TEXT")
    private String newReadIds;


    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;

    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;

    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;
}
