package com.tykj.dev.device.user.subject.entity.bto;

import com.google.common.collect.Lists;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * AreaUnit.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/26 at 8:11 下午
 */
@Data
@NoArgsConstructor
public class AreaUnit {

    private Integer id;

    private String name;

    private Integer type;

    private String orders;

    private Integer fatherId;

    private String unitName;

    /**
     * 默认等于{@link #unitList}里的第一个元素
     */
    private Unit unit;

    /**
     * 为以后的扩展准备，防止一个地区有多个单位出现
     */
    private List<Unit> unitList;

    public AreaUnit(Area area, Units units) {
        this.id = area.getId();
        this.name = area.getName();
        this.type = area.getType();
        this.orders = area.getOrders();
        this.fatherId = area.getFatherId();
        this.unitName = units.getName();
        this.unit = new Unit(units.getUnitId(), units.getName(), units.getUnitDesc(), units.getCode());
        this.unitList = Lists.newArrayList(this.unit);
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    class Unit {
        private Integer unitId;

        private String name;

        private String unitDesc;

        private String code;
    }
}
