package com.tykj.dev.device.zxing.service.impl;

import com.tykj.dev.device.zxing.dao.PackageVersionDao;
import com.tykj.dev.device.zxing.entity.PackageVersion;
import com.tykj.dev.device.zxing.service.PackageVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackageVersionServiceImpl implements PackageVersionService {

    @Autowired
    private PackageVersionDao packageVersionDao;

    @Override
    public PackageVersion getVersion() {
        return packageVersionDao.findById(1).get();
    }

    /**
     * 自动升级版本号，版本号+1
     * @param version
     * @return
     */
    private String autoUpgradeVersion(String version){
        if (version.equals("")) {
            version = "0.0.0.0";
        }
        //将版本号拆解成整数数组
        String[] arr = version.split("\\.");
        int[] ints=new int[arr.length];
        for (int i = 0; i < arr.length; i++) {
            ints[i] = Integer.valueOf(arr[i]);
        }

        //递归调用
        this.autoUpgradeVersion(ints, ints.length - 1);

        //数组转字符串
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ints.length; i++) {
            sb.append(ints[i]);
            if ((i + 1) != ints.length) {
                sb.append(".");
            }
        }
        return sb.toString();
    }

    /**
     * 自动升级版本号，版本号+1
     * @param ints
     * @param index
     */
    private void autoUpgradeVersion(int[] ints, int index){
        if(index == 0){
            ints[0] = ints[0] + 1;
        }
        else {
            int value = ints[index] + 1;
            if (value < 10) {
                ints[index] = value;
            }
            else {
                ints[index] = 0;
                autoUpgradeVersion(ints, index - 1);
            }
        }
    }
}
