# 核查业务说明
## 流程说明
![核查流程](images/confirmcheck/核查流程.jpg)

## 涉及到的任务状态与术语说明

**任务状态号**

| 状态号      | 说明                       | 备注                         |
| ----------- | -------------------------- | ---------------------------- |
| 140-141-142 | 区自查用到的状态号         | 代表等待区A-等待区B-等待市审 |
| 160-161     | 市/省自查用到的状态号      | 代表等待市/省A - 等待市/省B  |
| 130-131     | 检查统计任务会用到的状态号 |                              |
| 110-111     | 核查统计任务会用到的状态号 |                              |

**术语**

| 术语名   | 说明                                 |
| -------- | ------------------------------------ |
| 自查     | 某省/市/区自己检查自己库房任务的统称 |
| 核查情况 | 发起检查的单位对下级单位的进度说明   |
| 核查结果 | 省对下级单位的审核进度说明           |


## 市与区的检查页面

![市](images/confirmcheck/市对区检查图.jpg)

### 区自查流程

**任务流程**

![区自查流程](images/confirmcheck/区自查流程.jpg)

**实现说明**
对于自查任务本身的状态应当有
1. 等待区专管员A处理 id = 120
   
2. 等待区专管员B处理 id = 121

3. 等待市专管员处理 id = 122

4. 完结 id = 9999

**核查情况**

如上图所示，核查情况与自查任务的状态有着对应的关系

| 任务状态          | 核查情况                                   |
| ----------------- | -------------------------------------- |
| 等待区专管员A处理 | 无                                     |
| 等待区专管员B处理 | 进行中                                 |
| 等待市专管员处理  | 等待市审核                                 |
| 完结              | 完成                                   |
| 等待区专管员A处理 | 未通过(可以通过Task里的特殊标记来实现) |


**核查结果**

| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 等待重做   |

### 市本级自查流程

![市本级自查](images/confirmcheck/市自查流程.jpg)

**实现说明**
对于自查任务本身的状态应当有
1. 等待市专管员A处理 id = 160

2. 等待市专管员B处理 id = 161

3. 完结 id = 9999

**核查情况**

如上图所示，核查情况与自查任务的状态有着对应的关系

| 任务状态         | 结果                                   |
| ----------------- | -------------------------------------- |
| 等待市专管员A处理 | 无                                     |
| 等待市专管员B处理 | 进行中                                 |
| 完结              | 完成                                   |


**核查结果**

| 核查情况                     | 核查结果 |
| ---------------------------- | -------- |
| 在完成以前的状态             | 无       |
| 完成状态                     | 等待省审核   |
| 完成且省审核通过                   | 无误     |
| 完成且省审核未通过(点击回退按钮了) | 未通过   |

### 关于回退

市对区的回退

让当前任务本身回滚到重做的初始状态

- 重置Task任务本身的任务状态，使其回滚到等待专管员A处理时的状态，
并在Task里添加特殊的回滚标记，用来鉴别这是一个回滚任务
  

- 重置该自查详情里的各个装备的自查详情请看
  
- 该detail对应的stat数据里相应的数据剔除(写一个通用的剔除方法),
否则在第二次审核通过的时候会重复计算一次数据
  
  
省对区的回退

让当前任务完结，并标记为未通过， 拷贝相关数据，重新发起一个新的任务

- 完结当前Task,发起新的Task，数据拷贝来源于当前Task

- 将当前自查数据从stat统计数据里清除掉,该条detail数据作为历史数据来保留

## 省对市的页面

![省对市核查图](images/confirmcheck/省对市核查图.jpg)

省对市的`核查情况`与`核查结果`可以看作是该市下所有区自查的
核查情况`与`核查结果`的一个总览结果

**核查情况**

此页面下的核查情况如下表所示

| 核查情况 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查状态为无           |
| 待审核   | 该市级下有任意一个区的核查状态为待审核 |
| 已完成   | 该市级下所有区的核查状态为已完成       |
| 进行中   | 除开以上的三种情况剩下的都为进行中     |

**核查结果**

此页面下的核查情况如下表所示

| 核查结果 | 触发条件                               |
| -------- | -------------------------------------- |
| 无       | 该市级下所有区的核查结果为无           |
| 待省审核   | 该市级下有任意一个区核查结果为等待省审核 |
| 未通过   | 该市级下有任意一个区的核查结果为未通过     |
| 无误   | 该市级下所有区的核查结果都为无误     |
| 审核中   | 其他情况下为审核中     |

## 关于自查状态问题的说明
**发起人是省**
- 状态转换 专管员A - 专管员B - 结束

**发起人是市**
- 区自查 专管员A - 专管员B - 市审核 - 结束
- 市本级自查 专管员A - 专管员B - 结束

## 性能优化与监控





