/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.SendJsonOperation;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SettingsRanges {
    private SettingsRanges() {
    }

    public static Map<String, String> getRanges(List<String> list, Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) throws IllegalStateException, ConnectionException, JsonParseException, JsonMappingException, IOException {
        if (linkOsInformation.getMajor() < 3 || linkOsInformation.getMajor() == 3 && linkOsInformation.getMinor() < 2) {
            throw new IllegalStateException("Not supported for LinkOS versions less than 3.2");
        }
        String string = "";
        for (String object2 : list) {
            string = string + "\"" + object2 + "\"" + ",";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = String.format("{}{'get':{ 'field': ['range'], 'name': [%s] }}".replace("'", "\""), string);
        SendJsonOperation sendJsonOperation = new SendJsonOperation(connection, printerLanguage, string2);
        HashMap<String, String> hashMap = new HashMap();
        hashMap = SettingsRanges.parseJsonForRanges(sendJsonOperation.execute());
        return hashMap;
    }

    public static Map<String, String> parseJsonForRanges(String string) throws IOException, JsonParseException, JsonMappingException {
        TypeReference<Map<String, Range>> typeReference = new TypeReference<Map<String, Range>>(){};
        Map map = (Map)JacksonObjectMapperFactory.getInstance().readValue(string, (TypeReference)typeReference);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Range range = (Range)map.get(string2 = (String)iterator.next());
            hashMap.put(string2, range != null ? range.getRange() : null);
        }
        return hashMap;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    private static class Range {
        String range;

        public Range(String string) {
            this.range = string;
        }

        public Range() {
            this.range = null;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String string) {
            this.range = string;
        }
    }
}

