package com.tykj.dev.device.library.service.impl;

import com.tykj.dev.device.library.repository.DeviceLogDao;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;


/**
 * @author dengdiyi
 */
@Service
public class DeviceLogServiceImpl implements DeviceLogService {

    @Autowired
    private DeviceLogDao deviceLogDao;

    @Override
    public DeviceLogDto addLog(DeviceLogDto deviceLogDto) {
        DeviceLog deviceLogEntity = deviceLogDto.toDo();
        return deviceLogDao.save(deviceLogEntity).parse2Dto();
    }

    @Override
    public DeviceLogDto getOne(Integer id) {
        Optional<DeviceLog> deviceLogEntity = deviceLogDao.findById(id);
        if (deviceLogEntity.isPresent()){
            return deviceLogEntity.get().parse2Dto();
        }
        else {
            throw new ApiException(ResultUtil.failed("查询的id不存在"));
        }
    }

}
