package com.tykj.dev.device.repair.service.impl;

import com.tykj.dev.device.repair.repository.RepairDetailDao;
import com.tykj.dev.device.repair.service.RepairDetailService;
import com.tykj.dev.device.repair.subject.domin.RepairDetail;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepairDetailServiceImpl.java
 * @Description TODO
 * @createTime 2020年08月25日 10:37:00
 */
@Service
public class RepairDetailServiceImpl implements RepairDetailService {
    @Autowired
    RepairDetailDao deviceRepairDetailDao;

    @Override
    public RepairDetail save(RepairDetail deviceRepairDetailEntity) {
        return deviceRepairDetailDao.save(deviceRepairDetailEntity);
    }

    @Override
    public boolean delete(Integer id) {
        return false;
    }

    @Override
    public List<RepairDetail> findAll() {
        return deviceRepairDetailDao.findAll();
    }

    @Override
    public RepairDetail update(RepairDetail deviceRepairDetailEntity) {
        return deviceRepairDetailDao.save(deviceRepairDetailEntity);
    }

    @Override
    public List<RepairDetail> findByBillId(Integer billId) {
        return deviceRepairDetailDao.findByDeviceRepairBillId(billId);
    }

    @Override
    public RepairDetail updateIdAndStatus(Integer id, Integer status) {
        Optional<RepairDetail> repairDetail = deviceRepairDetailDao.findById(id);
        if (repairDetail.isPresent()){
            RepairDetail repairDetail1 = repairDetail.get();
            repairDetail1.setRepairStatus(status);
            deviceRepairDetailDao.save(repairDetail1);
            return repairDetail1;
        }
        else {
            throw new ApiException(ResultUtil.failed("所查询ID不存在"));
        }
    }
}
