package com.tykj.dev.device.repair.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for repair_detail
 * 装备维修账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update repair_detail set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备维修详情")
public class RepairDetail {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;


	/**
	* 装备id
	*/
	@ApiModelProperty(value = "装备id")
	private Integer deviceId;
	/**
	* 型号
	*/
	@ApiModelProperty(value = "型号")
	private String model;
	/**
	* 名称
	*/
	@ApiModelProperty(value = "名称")
	private String name;
	/**
	* 类型
	*/
	@ApiModelProperty(value = "类型")
	private Integer type;
	/**
	* 装备序列号
	*/
	@ApiModelProperty(value = "装备序列号")
	private String seqNumber;
	/**
	* rfid表面号
	*/
	@ApiModelProperty(value = "rfid表面号")
	private String rfidSurfaceId;

	/**
	 * 维修单id
	 */
	@ApiModelProperty(value = "维修单id")
	private Integer deviceRepairBillId;

	/**
	* 所在单位
	*/
	@ApiModelProperty(value = "所在单位")
	private String locationUnit;
	/**
	* 所属单位
	*/
	@ApiModelProperty(value = "所属单位")
	private String ownUnit;
	/**
	* 维修状态
	*/
	@ApiModelProperty(value = "维修状态")
	private Integer repairStatus;
	/**
	* 维修备注
	*/
	@ApiModelProperty(value = "维修备注")
	private String remark;
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag =0;

}
