package com.tykj.dev.device.train.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.train.entity.TrainTheme;
import com.tykj.dev.device.train.entity.vo.*;
import com.tykj.dev.device.train.service.TrainTaskService;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.ArrayList;
import java.util.List;


/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainJobController.java
 * @Description TODO
 * @createTime 2020年08月16日 21:26:00
 */
@RestController
@RequestMapping(value = "/job/train")
@AutoDocument
@Api(tags = "专管员培训业务",description = "培训业务接口")
@Slf4j
public class TrainJobController {

    @Autowired
    TrainThemeService trainThemeService;
    @Autowired
    MgrcertService mgrcertService;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserService userService;
    @Autowired
    MyWebSocket myWebSocket;
    @Autowired
    TaskService taskService;
    @Autowired
    TrainTaskService trainTaskService;
    @Autowired
    TaskLogService taskLogService;


    // 发起培训给选中人员都发一个代办任务报名，此任务在发起人跟踪里
    /**
     * 新建培训信息
     * 首先创建task(发起人task) 在创建状态为新建(id_done为1)以及报名中待job，在给所有的专管员发起一个job（待报名）
     */
    @ApiOperation(value = "1.培训业务新建接口",notes = "有两类人员，一必须培训的人员，这里状态为报名确认，只需要确认就ok，2。不是必须报名的人员 状态 待报名，需要让用户选择报名 或不报名")
    @PostMapping("/initiate")
    public ResponseEntity<TrainTheme> newTrain(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody TrainThemeAddVo trainThemeAddVo){
        TrainTheme trainTheme = trainThemeService.save(trainThemeAddVo.toDo());
//        List<User> userList = userService.findSubordinate(securityUser.getCurrentUserInfo().getUserId());
        List<Integer> needTrain=trainThemeAddVo.getJoinUserIds();
        List<Integer> normal=trainThemeAddVo.getNoJoinUserIds();

//        userList.forEach(
//                user -> {
//            if (user.getTrainStatus()==1 || user.getTrainStatus()==2){
//                needTrain.add(user.getUserId());
//            }else {
//                normal.add(user.getUserId());
//            }
//                }
//        );
        // 1.用户报名
        trainTheme.setJoinUserId(JacksonUtil.toJSon(needTrain));
        trainTheme.setNoJoinUserId(JacksonUtil.toJSon(normal));
        trainTheme.setSignUp("x");

        List<Integer> integers=new ArrayList<>();
        integers.add(securityUser.getCurrentUserInfo().getUserId());
        Task task=  taskService.start(new TaskBto(StatusEnum.TRAIN1000.id,trainTheme.getName(),null,null,null,trainTheme.getTrainId(),13,0,null,integers));

        //1 新建培训
//        jobService.addEntity(new JobEntity(taskEntity.getId(),1,39,0,"x"+securityUser.getCurrentUserInfo().getUserId()+"x",0));
        //2. 报名中
//        JobEntity jobEntity=new JobEntity(taskEntity.getId(),0,trainTheme.getTrainStatus(),securityUser.getCurrentUserInfo().getUserId(),"x"+securityUser.getCurrentUserInfo().getUserId()+"x",0);
//        jobService.addEntity(jobEntity);

        needTrain.forEach(
                id->{
                    //4 报名确认
//                    TaskSaveVo taskSaveVo1=new TaskSaveVo(trainTheme.getName(),trainTheme.getTrainId(),36,taskEntity.getId(),"."+taskEntity.getId()+".",13,null,id,"x","x");
//                    TaskEntity taskEntity1 = taskService.addEntity(taskSaveVo1.toDo());
//                    JobEntity jobEntity1=new JobEntity(taskEntity1.getId(),0,36,id,"x"+id+"x",0);
//                    jobService.addEntity(jobEntity1);
                    List<Integer> list=new ArrayList<>();
                    list.add(id);
                    taskService.start(new TaskBto(StatusEnum.TRAIN1001.id,trainTheme.getName(),task.getId(),task.getId().toString(),trainTheme.getTrainId(),13,securityUser.getCurrentUserInfo().getUnitsId(),0,null,list));

                }
        );
        normal.forEach(
                id->{
                    //3 待报名
//                    TaskSaveVo taskSaveVo1=new TaskSaveVo(trainTheme.getName(),trainTheme.getTrainId(),37,taskEntity.getId(),"."+taskEntity.getId()+".",13,null,id,"x","x");
//                    TaskEntity taskEntity1 = taskService.addEntity(taskSaveVo1.toDo());
//                    JobEntity jobEntity1=new JobEntity(taskEntity1.getId(),0,37,id,"x"+id+"x",0);
//                    jobService.addEntity(jobEntity1);
                    List<Integer> list=new ArrayList<>();
                    list.add(id);
                    taskService.start(new TaskBto(StatusEnum.TRAIN1002.id,trainTheme.getName(),task.getId(),task.getId().toString(),trainTheme.getTrainId(),13,securityUser.getCurrentUserInfo().getUnitsId(),0,null,list));
                }
        );
        TaskLogBto taskLogBto = new TaskLogBto(task.getId(),"发起培训",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainTheme);
    }

    //报名

    /**
     * 待报名 （所调用的接口）
     *
     * @param signUpReturn
     * @return
     */
    @ApiOperation(value = "2。报名和确认接口",notes = "若是确认请填写confirm为1，若报名returns=0、若不报名returns=1")
    @PostMapping("/signUp")
    public ResponseEntity<TrainTheme> signUp(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody signUpReturn signUpReturn){
        TrainTheme trainTheme = trainThemeService.findById(signUpReturn.getTrainThemeId());
        TaskBto taskBto= taskService.get(signUpReturn.getTaskId());
        if (signUpReturn.getReturns()==0) {
            taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1003,-1);
//           JobEntity jobEntity = jobService.getOne(signUpReturn.getJobId());
//           jobEntity.setIsDone(1);
//           //4 等待培训
//           jobService.update(jobEntity);
//           JobEntity jobEntity1 = new JobEntity();
//           BeanUtils.copyProperties(jobEntity, jobEntity1);
//           jobEntity1.setId(null);
//           jobEntity1.setIsDone(0);
//           jobEntity1.setBillStatus(35);
//           jobEntity1.setBelongUserId(0);
//           jobService.addEntity(jobEntity1);
//           TaskEntity taskEntity = taskService.getOne(jobEntity.getTaskId());
//           taskEntity.setBillStatus(35);
//           taskService.update(taskEntity);
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"报名",null);
            taskLogService.addLog(taskLogBto);
           trainTheme.setSignUp(trainTheme.getSignUp()+securityUser.getCurrentUserInfo().getUserId()+"x");
       }else {
//            JobEntity jobEntity = jobService.getOne(signUpReturn.getJobId());
//            jobEntity.setIsDone(1);
//            jobService.update(jobEntity);
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"不报名",null);
            taskLogService.addLog(taskLogBto);
            taskService.moveToEnd(taskBto);
       }
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

    /**
     * 报名结束
     * @param trainId
     * @return
     */
    @GetMapping("/signUpEnd/{trainId}")
    public ResponseEntity<TrainTheme> signUpEnd(@PathVariable Integer trainId){
        TrainTheme trainTheme = trainThemeService.findById(trainId);
        //查询所有必须报名而没有报名的task 状态直接转为待培训
        trainTaskService.selectBillidAndBillType(trainId,13,StatusEnum.TRAIN1001.id).forEach(
                taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1003,-1)
        );
        trainTaskService.selectBillidAndBillType(trainId,13,StatusEnum.TRAIN1002.id).forEach(
                taskBto -> taskService.moveToEnd(taskBto)
        );

        //未报名统一处理为为报名
//        taskService.findBybullIdAndBussType(3,13).forEach(
//                taskEntity -> {
////                    JobEntity jobEntity=  taskUtils.getCurrentJob(taskEntity.getId());
////                    jobEntity.setIsDone(1);
////                    jobService.update(jobEntity);
//                }
//        );
        trainTaskService.selectBillidAndBillType(trainId,13,StatusEnum.TRAIN1000.id).forEach(
                taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1010)
        );
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        taskEntity.setBillStatus(7);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setId(null);
//        //5 待培训
//        jobEntity1.setBillStatus(7);
//        jobService.addEntity(jobEntity1);
        //5 待培训
        trainTheme.setTrainStatus(StatusEnum.TRAIN1010.id);
        myWebSocket.sendMessage1();
        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

    //培训中
    @GetMapping("/inTraining/{trainId}")
    public ResponseEntity<TrainTheme> inTraining(@PathVariable Integer trainId){
        TrainTheme trainTheme = trainThemeService.findById(trainId);
        trainTaskService.selectBillidAndBillType(trainId,13,StatusEnum.TRAIN1010.id).forEach(
                taskBto -> taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1004, taskBto.getInvolveUserIdList().get(0))
        );
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        taskEntity.setBillStatus(8);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setId(null);
//        //5 培训中
//        jobEntity1.setBillStatus(8);
//        jobService.addEntity(jobEntity1);
        //5 培训中
        trainTheme.setTrainStatus(StatusEnum.TRAIN1004.id);
        myWebSocket.sendMessage1();
        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
    }



//    //录入成绩
//    @GetMapping("/{trainId}")
//    public ResponseEntity<TrainTheme> resultsEntry(@PathVariable Integer trainId){
//        TrainTheme trainTheme = trainThemeService.findById(trainId);
//
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setId(null);
//        //6 录入成绩
//        jobEntity1.setBillStatus(6);
//        jobService.addEntity(jobEntity1);
//        //6 录入成绩
//        trainTheme.setTrainStatus(6);
//        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
//    }

    //市培训待审核
    @ApiOperation(value = "3 录入成绩后调用的接口",notes = "状态改为'市培训申请发证")
    @PostMapping("/gradesGrade")
    public ResponseEntity<TrainTheme> cityAudit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//        TaskEntity taskEntity= taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(),trainTheme.getTrainId(),13);
        TaskBto taskBto=trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(),13);
        taskBto.setOwnUnit(1);
        taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1005);
//        taskEntity.setBillStatus(32);
//        taskEntity.setOwnUnit(1);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        //10市待审核
//        jobEntity1.setId(null);
//        jobEntity1.setBillStatus(32);
//        jobEntity1.setBelongUserId(0);
//        jobService.addEntity(jobEntity1);
        //10 市待审核状态
//        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
        trainTheme.setTrainStatus(StatusEnum.TRAIN1005.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"申请发证",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
    }

//    //市培训申请
//    @ApiOperation(value = "市培训待审核状态 审核接口",notes = "审核通过状态：'市培训申请发证'，不通过则退回状态成绩录入状态")
//    @GetMapping("/certificateApplication")
//    public ResponseEntity<TrainTheme> certificateApplication(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
//
//        if (gradeEntryVo.getThrough()==0) {
//            //申请发证
//            TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//            TaskEntity taskEntity = taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(), trainTheme.getTrainId(), 13);
//            taskEntity.setBillStatus(32);
//            //省
//            taskEntity.setOwnUnit(1);
//            taskService.update(taskEntity);
//            JobEntity jobEntity = taskUtils.getCurrentJob(taskEntity.getId());
//            jobEntity.setIsDone(1);
//            jobService.update(jobEntity);
//            JobEntity jobEntity1 = new JobEntity();
//            BeanUtils.copyProperties(jobEntity, jobEntity1);
//            jobEntity1.setIsDone(0);
//            jobEntity1.setId(null);
//            jobEntity1.setBillStatus(32);
//            jobEntity1.setBelongUserId(0);
//            jobService.addEntity(jobEntity1);
////            trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//            trainTheme.setTrainStatus(32);
//            return ResponseEntity.ok(trainThemeService.save(trainTheme));
//        }else {
//            TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//            TaskEntity taskEntity = taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(), trainTheme.getTrainId(), 13);
//            taskEntity.setBillStatus(31);
//            //省
//            taskEntity.setOwnUnit(1);
//            taskService.addEntity(taskEntity);
//            JobEntity jobEntity = taskUtils.getCurrentJob(taskEntity.getId());
//            jobEntity.setIsDone(1);
//            jobService.update(jobEntity);
//            JobEntity jobEntity1 = new JobEntity();
//            BeanUtils.copyProperties(jobEntity, jobEntity1);
//            jobEntity1.setId(null);
//            jobEntity1.setIsDone(0);
//            jobEntity1.setBillStatus(31);
//            jobEntity1.setBelongUserId(taskEntity.getStartUserId());
//            jobEntity1.setInvoleUserId(jobEntity1.getInvoleUserId().replace(securityUser.getCurrentUserInfo().getUserId()+"x",""));
////            trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//            jobService.addEntity(jobEntity1);
//            trainTheme.setTrainStatus(31);
//            return ResponseEntity.ok(trainThemeService.save(trainTheme));
//        }
//    }

//
//    //市培训待审核
//    @ApiOperation(value = "3 录入成绩后调用的接口",notes = "状态改为'市培训待审核")
//    @GetMapping("/gradesGrade")
//    public ResponseEntity<TrainTheme> cityAudit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
//        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//        TaskEntity taskEntity= taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(),trainTheme.getTrainId(),13);
//
//        taskEntity.setBillStatus(31);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        //10市待审核
//        jobEntity1.setId(null);
//        jobEntity1.setBillStatus(31);
//        jobEntity1.setBelongUserId(gradeEntryVo.getAuditId());
//        jobEntity1.setInvoleUserId(jobEntity1.getInvoleUserId()+gradeEntryVo.getAuditId()+"x");
//        jobService.addEntity(jobEntity);
//        //10 市待审核状态
////        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
//        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//        trainTheme.setTrainStatus(31);
//        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
//    }
//
//    //市培训申请
//    @ApiOperation(value = "市培训待审核状态 审核接口",notes = "审核通过状态：'市培训申请发证'，不通过则退回状态成绩录入状态")
//    @GetMapping("/certificateApplication")
//    public ResponseEntity<TrainTheme> certificateApplication(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
//
//        if (gradeEntryVo.getThrough()==0) {
//            //申请发证
//            TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//            TaskEntity taskEntity = taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(), trainTheme.getTrainId(), 13);
//            taskEntity.setBillStatus(32);
//            //省
//            taskEntity.setOwnUnit(1);
//            taskService.update(taskEntity);
//            JobEntity jobEntity = taskUtils.getCurrentJob(taskEntity.getId());
//            jobEntity.setIsDone(1);
//            jobService.update(jobEntity);
//            JobEntity jobEntity1 = new JobEntity();
//            BeanUtils.copyProperties(jobEntity, jobEntity1);
//            jobEntity1.setIsDone(0);
//            jobEntity1.setId(null);
//            jobEntity1.setBillStatus(32);
//            jobEntity1.setBelongUserId(0);
//            jobService.addEntity(jobEntity1);
////            trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//            trainTheme.setTrainStatus(32);
//            return ResponseEntity.ok(trainThemeService.save(trainTheme));
//        }else {
//            TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//            TaskEntity taskEntity = taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(), trainTheme.getTrainId(), 13);
//            taskEntity.setBillStatus(31);
//            //省
//            taskEntity.setOwnUnit(1);
//            taskService.addEntity(taskEntity);
//            JobEntity jobEntity = taskUtils.getCurrentJob(taskEntity.getId());
//            jobEntity.setIsDone(1);
//            jobService.update(jobEntity);
//            JobEntity jobEntity1 = new JobEntity();
//            BeanUtils.copyProperties(jobEntity, jobEntity1);
//            jobEntity1.setId(null);
//            jobEntity1.setIsDone(0);
//            jobEntity1.setBillStatus(31);
//            jobEntity1.setBelongUserId(taskEntity.getStartUserId());
//            jobEntity1.setInvoleUserId(jobEntity1.getInvoleUserId().replace(securityUser.getCurrentUserInfo().getUserId()+"x",""));
////            trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//            jobService.addEntity(jobEntity1);
//            trainTheme.setTrainStatus(31);
//            return ResponseEntity.ok(trainThemeService.save(trainTheme));
//        }
//    }



    //市培训申请发证审核  待确认
    @ApiOperation(value = "市培训申请发证状态 调用接口" ,notes = "下一步'市培训申请发证审核'")
    @PostMapping("/isApply")
    public ResponseEntity<TrainTheme> provinceAudit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        TaskBto taskBto=trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(),13);
        taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1006,gradeEntryVo.getAuditId());



//        TaskEntity taskEntity= taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        taskEntity.setBillStatus(33);
//        taskService.update(taskEntity);
//
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobEntity.setBelongUserId(securityUser.getCurrentUserInfo().getUserId());
//        jobEntity.setInvoleUserId(jobEntity.getInvoleUserId()+securityUser.getCurrentUserInfo().getUserId()+"x");
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setId(null);
//        //市培训发证审核
//        jobEntity1.setBillStatus(33);
//        jobEntity1.setBelongUserId(gradeEntryVo.getAuditId());
//        jobEntity1.setInvoleUserId(jobEntity1.getInvoleUserId()+gradeEntryVo.getAuditId()+"x");
//        jobService.addEntity(jobEntity1);
        //7 市培训申请发证审核
        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
        trainTheme.setTrainStatus(33);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"发证审核",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
    }



    //省培训发证审核
    @PostMapping("/audit")
    public ResponseEntity<TrainTheme> audit(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        TaskBto taskBto=trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(),13);
        taskService.moveToSpecial(taskBto,StatusEnum.TRAIN1007,gradeEntryVo.getAuditId());

//
//        TaskEntity taskEntity= taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        taskEntity.setBillStatus(34);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setIsDone(0);
//        //省培训发证审核
//        jobEntity1.setId(null);
//        jobEntity1.setBillStatus(34);
//        jobEntity1.setBelongUserId(gradeEntryVo.getAuditId());
//        jobEntity1.setInvoleUserId(jobEntity1.getInvoleUserId()+gradeEntryVo.getAuditId()+"x");
//        jobService.addEntity(jobEntity1);
        //7 省培训发证审核
        trainTheme.setIsCertificate(gradeEntryVo.getIsCertificate());
        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
        trainTheme.setTrainStatus(StatusEnum.TRAIN1007.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"发证待审核",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return  ResponseEntity.ok(trainThemeService.save(trainTheme));
    }



    @ApiOperation(value = "省培训发证审核以及市培训申请发证审核调用接口",notes = "同意培训完成")
    @PostMapping("/auditResult")
    public ResponseEntity<TrainTheme> gradeeEntry(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
        //向专管员证书表中添加数据

            gradeEntryVo.getGradeEntryList().forEach(
                    gradeEntry -> {
                        if (gradeEntry.getCertificate()==0){
                            mgrcertService.save(gradeEntry.toDo());
                        }
                    }
            );
        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
        //给培训报名的人员都发起一个通知，查看自己都证书
        TaskBto taskBto=trainTaskService.selectFatherIsNullAndBillidAndBillType(trainTheme.getTrainId(),13);
        taskService.moveToEnd(taskBto);
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        //8 培训完成
//        taskEntity.setBillStatus(15);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        //完结待确认
//        jobService.update(jobEntity);
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setId(null);
//        jobEntity1.setBillStatus(15);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setBelongUserId(taskEntity.getStartUserId());
//        jobEntity1.setInvoleUserId("x"+taskEntity.getStartUserId()+"x");
//        jobService.addEntity(jobEntity1);
       
                    trainTaskService.selectBillidAndBillType(gradeEntryVo.getTrainThemeId(),13,StatusEnum.TRAIN1003.id).forEach(
                            taskBto1 -> {
//                                taskBto1.setCurrentPoint(0);
                                taskService.moveToSpecial(taskBto1, StatusEnum.TRAIN1009,taskBto1.getInvolveUserIdList().get(0));
                            }
                    );
                    //9 成绩待确认
//                    TaskEntity taskEntity1=taskService.findByStartUserIdAndBillIdAndBussType(id,trainTheme.getTrainId(),13);
//                    taskEntity1.setBillStatus(38);
//                    taskService.update(taskEntity1);
//                    JobEntity jobEntity2 = taskUtils.getCurrentJob(taskEntity1.getId());
//                    jobEntity2.setIsDone(1);
//                    jobService.update(jobEntity2);
//                    JobEntity jobEntity3=new JobEntity();
//                    BeanUtils.copyProperties(jobEntity2,jobEntity3);
//                    jobEntity3.setId(null);
//                    jobEntity3.setBelongUserId(id);
//                    jobEntity3.setInvoleUserId("x"+id+"x");
//                    jobEntity3.setBillStatus(38);
//                    jobEntity3.setIsDone(0);
//                    jobService.addEntity(jobEntity3);
//                    
//        );
        /**
         * 15
         */
        trainTheme.setTrainStatus(StatusEnum.END.id);
        trainTheme.setGood(gradeEntryVo.getGood());
        trainTheme.setPass(gradeEntryVo.getPass());

        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
        trainThemeService.save(trainTheme);
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"审核通过",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok( trainTheme);
        //修改业务都状态
    }



//    //市审核 是否通过 培训完成
//    public ResponseEntity<TrainTheme> gradeeEntry1(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody GradeEntryVo gradeEntryVo){
//        //向专管员证书表中添加数据
//        List<Mgrcert> list=new ArrayList<>();
//        gradeEntryVo.getGradeEntryList().forEach(
//                gradeEntry -> list.add(gradeEntry.toDo())
//        );
//        mgrcertService.saveAll(list);
//
//
//        TrainTheme trainTheme = trainThemeService.findById(gradeEntryVo.getTrainThemeId());
//        //给培训报名的人员都发起一个通知，查看自己都证书
//        List<Integer> ids= StringSplitUtil.userIdSplit(trainTheme.getSignUp());
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        //8 待确认
//        taskEntity.setBillStatus(13);
//        taskService.update(taskEntity);
//        JobEntity jobEntity=  jobService.findTaskIdAndinvoleUserIdLike(taskEntity.getId(),securityUser.getCurrentUserInfo().getUserId());
//        jobEntity.setIsDone(1);
//        //培训结束
//        jobService.update(jobEntity);
//        //发起人通知
//        //给所有培训人员培训结果通知
//        //通知
//        JobEntity jobEntity1=new JobEntity();
//        BeanUtils.copyProperties(jobEntity,jobEntity1);
//        jobEntity1.setId(null);
//        jobEntity1.setBillStatus(13);
//        jobEntity1.setIsDone(0);
//        jobEntity1.setBelongUserId(taskEntity.getStartUserId());
//        jobEntity1.setInvoleUserId("x"+taskEntity.getStartUserId()+"x");
//        jobService.addEntity(jobEntity1);
//
//        ids.forEach(
//                id->{
//                    //9 培训结果
//                    TaskEntity taskEntity1=taskService.findByStartUserIdAndBillIdAndBussType(id,trainTheme.getTrainId(),13);
//                    taskEntity1.setBillStatus(13);
//                    taskService.update(taskEntity1);
//                    JobEntity jobEntity2 = taskUtils.getCurrentJob(taskEntity1.getId());
//                    jobEntity2.setIsDone(1);
//                    jobService.addEntity(jobEntity2);
//                    JobEntity jobEntity3=new JobEntity();
//                    BeanUtils.copyProperties(jobEntity2,jobEntity3);
//                    jobEntity3.setId(null);
//                    jobEntity3.setBillStatus(13);
//                    jobEntity3.setIsDone(0);
//                    jobService.addEntity(jobEntity3);
//
//                }
//        );
//        /**
//         * 培训结束
//         */
//        trainTheme.setTrainStatus(9);
//        trainTheme.setTrainingResults(JacksonUtil.toJSon(gradeEntryVo.getGradeEntryList()));
//        return ResponseEntity.ok( trainTheme);
//        //修改业务都状态
//    }


    //考情 1.正常参加 2.为参加 3.请假
    //分数
    //评价 1.优秀 2.良好 3.及格 4 不及格
    private String toString(GradeEntry gradeEntry){
        return gradeEntry.getUserId()+"-"+gradeEntry.getAttendance()+"-"+gradeEntry.getScore()+"-"+gradeEntry.getCertificate();

    }




//    /**
//     * 培训完成待确认
//     *
//     * @param signUpReturn
//     * @return
//     */
//    @ApiOperation(value = "end。培训完成待确认")
//    @PostMapping("/completionConfirmed")
//    public ResponseEntity<Boolean> completionConfirmed(@RequestBody signUpReturn signUpReturn){
//        TrainTheme trainTheme = trainThemeService.findById(signUpReturn.getTrainThemeId());
//        TaskEntity taskEntity=taskService.findByParentAndBillIdAndBussType(0,trainTheme.getTrainId(),13);
//        //13
//        taskEntity.setBillStatus(13);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
//        myWebSocket.sendMessage1();
//        return ResponseEntity.ok(true);
//    }

    /**
     *成绩查看确认
     * @param signUpReturn
     * @return
     */
    @ApiOperation(value = "end。成绩查看确认接口")
    @PostMapping("/resultsConfirm")
    public ResponseEntity<Boolean> resultsConfirm(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser,@RequestBody signUpReturn signUpReturn){
        TrainTheme trainTheme = trainThemeService.findById(signUpReturn.getTrainThemeId());
        //给培训报名的人员都发起一个通知，查看自己都证书
//        TaskEntity taskEntity=taskService.findByStartUserIdAndBillIdAndBussType(securityUser.getCurrentUserInfo().getUserId(),trainTheme.getTrainId(),13);
        TaskBto taskBto = taskService.get(signUpReturn.getTaskId());
        taskService.moveToEnd(taskBto);
//        taskEntity.setBillStatus(13);
//        taskService.update(taskEntity);
//        JobEntity jobEntity= taskUtils.getCurrentJob(taskEntity.getId());
//        jobEntity.setIsDone(1);
//        jobService.update(jobEntity);
        myWebSocket.sendMessage1();
        return ResponseEntity.ok(true);
    }

    @ApiOperation(value = "报名页面和确认页面接口，查看成绩页面接口")
    @GetMapping("/train/{trainId}")
    public ResponseEntity<ByTrainingPeople> resultsConfirm(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId){
      return ResponseEntity.ok(trainThemeService.findByTrainingPeople(trainId,securityUser.getCurrentUserInfo().getUserId()));
    }

    @ApiOperation(value = "报名中请求的详情接口")
    @GetMapping("/trainRegistration/{trainId}")
    public ResponseEntity<TrainRegistrationVo> TrainRegistrationVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId){
        return ResponseEntity.ok(trainThemeService.findRegistrationVo(trainId));
    }

    @ApiOperation(value = "培训中请求接口请求的详情接口")
    @GetMapping("/trainTrainingVo/{trainId}")
    public ResponseEntity<TrainTrainingVo> TrainTrainingVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId){
        return ResponseEntity.ok(trainThemeService.findTrainTrainingVo(trainId));
    }

    @ApiOperation(value = "审核请求的详情接口")
    @GetMapping("/trainAuditVo/{trainId}")
    public ResponseEntity<TrainAuditVo> TrainAuditVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer trainId){
        return ResponseEntity.ok(trainThemeService.findTrainAuditVo(trainId));
    }

    @ApiOperation(value = "培训修改接口")
    @PostMapping("/trainUpdateVo")
    public ResponseEntity<TrainTheme> TrainRegistrationVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody TrainUpdateVo trainUpdateVo){
        return ResponseEntity.ok(trainThemeService.updateTrain(trainUpdateVo));
    }

}
