package com.tykj.dev.device.train.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.user.subject.entity.Mgrcert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ByTrainingPeople.java
 * @Description 被培训人vo类
 * @createTime 2020年08月18日 15:06:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ByTrainingPeople {
    /**
     * 培训id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训id")
    private Integer trainId;

    /**
     * 培训主题
     */
    @ApiModelProperty(value = "培训主题")
    private String name;

    /**
     * 报名截止时间
     */
    @ApiModelProperty(value = "报名截止时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date trainTime;

    /**
     *  发起人 originator
     */
    @ApiModelProperty(value = "发起人")
    private String  originatorName;

    /**
     *  发起人 originator
     */
    @ApiModelProperty(value = "发起人id")
    private Integer  originatorId;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位名称")
    private String unitsName;

    /**
     * 主办单位
     */
    @ApiModelProperty(value = "主办单位")
    private Integer unitsId;



    /**
     * 培训开始时间
     */
    @ApiModelProperty(value = "培训开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    /**
     * 培训结束时间
     */
    @ApiModelProperty(value = "培训结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 培训地点
     */
    @ApiModelProperty(value = "培训地点")
    private String trainLocation;

    /**
     * 主讲人
     */
    @ApiModelProperty(value = "主讲人")
    private String  speakerUserId;

    /**
     * 培训资料名称
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataName;

    /**
     * 培训url
     */
    @ApiModelProperty(value = "培训资料")
    private String trainDataUrl;
    /**
     * 培训简介
     */
    @ApiModelProperty(value = "trainSynopsis",name = "trainSynopsis")
    private String trainSynopsis;

    /**
     * 培训状态 1报名中  2待培训  3培训中
     */
    @ApiModelProperty(value = "培训状态",name = "trainStatus")
    private Integer trainStatus;

    /**
     * 发证状态
     */
    @ApiModelProperty(value = "发证状态",name = "isCertificate")
    private Integer isCertificate;

    @ApiModelProperty(value = "分数",name = "score")
    private String score;

    @ApiModelProperty(value = "评价",name = "evaluation")
    private String evaluation;
    /**
     * 证书
     */
    @ApiModelProperty(value = "证书",name = "mgrcert")
    private Mgrcert mgrcert;

    /**
     * 及格
     */
    @ApiModelProperty(value = "发证状态")
    private Integer pass;

    /**
     * 优秀
     */
    @ApiModelProperty(value = "发证状态")
    private Integer good;

}
