package com.tykj.dev.rfid.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class RFIDChangeInfoVo
 * @packageName com.tykj.dev.rfid.entity.vo
 **/
@Data
@ApiModel("从前端接收rfid变更信息")
public class RfidChangeInfoVo {

    @Min(value = 1)
    @ApiModelProperty(value = "装备ID",example = "1")
    private Integer deviceId;

    @ApiModelProperty(value = "新RFID卡号",example = "xxx1")
    private String newRfidCardId;

    @ApiModelProperty(value = "旧RFID卡号",example = "xxx1")
    private String oldRfidCardId;


}
