package com.tykj.dev.device.allot.subject.vo;

import com.tykj.dev.device.allot.subject.domin.AllotBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配发单类")
public class AllotBillSaveVo {

    @ApiModelProperty(value = "配发标题")
    private String title;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "配发单位")
    private String sendUnit;

    @ApiModelProperty(value = "接收单位")
    private String receiveUnit;

    @ApiModelProperty(value = "发件方(B岗位)")
    private Integer sendUserbId;

    @ApiModelProperty(value = "收件方(A岗位)")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "账单文件名")
    private String fileName;

    @ApiModelProperty(value = "账单文件地址URL")
    private String fileUrl;

    @ApiModelProperty(value = "配发设备数量")
    private Integer allotCount;

    @ApiModelProperty(value = "已配发设备数量")
    private Integer allotedCount;

    @ApiModelProperty(value = "配发出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配)")
    private String allotCheckDetail;

    @ApiModelProperty(value = "配发出库检查结果")
    private String allotCheckResult;

    @ApiModelProperty(value = "签发人")
    private String agent;

    @ApiModelProperty(value = "入库类型")
    private Integer allotType;

    public AllotBill toDo(){
        AllotBill allotBillEntity = new AllotBill();
        BeanUtils.copyProperties(this,allotBillEntity);
        allotBillEntity.setAllotStatus(0);
        return allotBillEntity;
    }
}
