package com.tykj.dev.device.confirmcheck.entity.domain;

import com.tykj.dev.device.confirmcheck.entity.vo.CheckDeviceStatVo;
import com.tykj.dev.device.confirmcheck.entity.vo.CheckStatVo;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Arrays;
import java.util.Date;

/**
 * DeviceCheckStat.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:09 下午
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_check_stat set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备核查统计")
@Table(name = "device_check_stat", schema = "device_check_stat")
@NoArgsConstructor
public class DeviceCheckStat {
    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 父标题
     */
    private String title;

    /**
     * 子标题
     */
    private String subtitle;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 统计信息以JSON形式存储
     */
    private String statInfo;

    /**
     * 创建用户id
     */
    @CreatedBy

    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy

    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    public DeviceCheckStat(String title, String subtitle, Date startTime, Date endTime, String statInfo) {
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = startTime;
        this.endTime = endTime;
        this.statInfo = statInfo;
    }

    /**
     * Do类转化为Vo类
     */
    public CheckStatVo toVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        //复制基本信息
        CheckStatVo initialStat = mapper.map(this, CheckStatVo.class);
        //解析JSON并赋值
        CheckDeviceStatVo[] checkDeviceStatVos = JacksonUtil.readValue(this.statInfo, CheckDeviceStatVo[].class);
        initialStat.setDeviceStatVoList(Arrays.asList(checkDeviceStatVos));
        return initialStat;
    }
}
