package com.tykj.dev.device.library.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.repository.DeviceLogDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.library.subject.vo.*;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/device")
@AutoDocument
@Api(tags = "装备管理模块",description = "装备管理接口")
public class DeviceLibraryController {
    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @Autowired
    private DeviceLogDao deviceLogDao;

    @ApiOperation(value = "模糊查询装备分页", notes = "可以通过这个接口查询装备")
    @PostMapping("/selectDevicePage")
    public ResponseEntity selectDevicePage(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        Page<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getPage(deviceLibrarySelectVo, deviceLibrarySelectVo.getPageable());
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "模糊查询装备列表", notes = "可以通过这个接口查询装备列表")
    @PostMapping("/selectDeviceList")
    public ResponseEntity selectDeviceList(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getList(deviceLibrarySelectVo);
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "查询所有装备列表", notes = "可以通过这个接口查询所有装备列表")
    @PostMapping("/selectAllDeviceList")
    public ResponseEntity selectAllDeviceList(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getAllList(deviceLibrarySelectVo);
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "查询检查装备列表", notes = "可以通过这个接口查询装备列表")
    @GetMapping("/selectCheckDeviceList")
    public ResponseEntity selectDeviceList() {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getCheckList();
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "模糊查询可配发的在库装备列表", notes = "可以通过这个接口查询可配发装备")
    @PostMapping("/selectAllotDeviceList")
    public ResponseEntity selectAllotDeviceList(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        List<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getAllotList(deviceLibrarySelectVo);
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "模糊查询核心装备分页", notes = "可以通过这个接口查询装备列表")
    @PostMapping("/core/feature/summary")
    public ResponseEntity selectCoreDevicePage(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        Page<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getCoreDevicePage(deviceLibrarySelectVo, deviceLibrarySelectVo.getPageable());
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "查询存在的装备名称", notes = "可以通过这个接口查询存在的装备名称")
    @GetMapping("/selectAllName")
    public ResponseEntity selectAllName() {
        return ResultUtil.success(deviceLibraryService.getAllName());
    }

    @ApiOperation(value = "模糊查询标签管理装备分页", notes = "可以通过这个接口查询装备列表")
    @PostMapping("/selectTagDevicePage")
    public ResponseEntity selectTagDevicePage(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        Page<DeviceLibrary> deviceLibraryEntities = deviceLibraryService.getTagPage(deviceLibrarySelectVo, deviceLibrarySelectVo.getPageable());
        return ResultUtil.success(deviceLibraryEntities);
    }

    @ApiOperation(value = "模糊查询核心装备统计分页", notes = "可以通过这个接口查询装备列表")
    @PostMapping("/core/stat/summary")
    public ResponseEntity getDeviceStatisticsPage(@RequestBody DeviceLibrarySelectVo deviceLibrarySelectVo) {
        Page<DeviceStatisticsVo> deviceStatisticsVos = deviceLibraryService.getDeviceStatisticsPage(deviceLibrarySelectVo, deviceLibrarySelectVo.getPageable());
        return ResultUtil.success(deviceStatisticsVos);
    }

    @ApiOperation(value = "查询核心装备详情的详情", notes = "可以通过这个接口查询核心装备详情的详情")
    @GetMapping("/core/feature/detail/{id}")
    public ResponseEntity getDeviceDetail(@PathVariable("id") int id) {
        DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(id);
        DeviceDetailVo deviceDetailVo = new DeviceDetailVo();
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //查询日志
        List<DeviceLogUserVo> deviceLogEntities = deviceLogDao.getAllByDeviceIdAndType(id, 0).stream()
                .map(DeviceLog::parse2Dto)
                .map(DeviceLogDto::toVo)
                .sorted(Comparator.comparing(DeviceLogUserVo::getCreateTime))
                .collect(Collectors.toList());
        libraryEntities.add(deviceLibraryEntity);
        if (deviceLibraryEntity.getIsPart()==0){
            List<DeviceLibrary> partList = deviceLibraryDao.getAllByPartParentIdAndIsPart(id,1);
            libraryEntities.addAll(partList);
            deviceDetailVo.setDeviceList(libraryEntities);
            deviceDetailVo.setDeviceLogEntityList(deviceLogEntities);
            return ResultUtil.success(deviceDetailVo);
        }
        else {
            if (deviceLibraryEntity.getPartParentId()==null) {
                deviceDetailVo.setDeviceList(libraryEntities);
                deviceDetailVo.setDeviceLogEntityList(deviceLogEntities);
                return ResultUtil.success(deviceDetailVo);
            }
            libraryEntities.add(deviceLibraryService.getOne(deviceLibraryEntity.getPartParentId()));
            deviceDetailVo.setDeviceList(libraryEntities);
            deviceDetailVo.setDeviceLogEntityList(deviceLogEntities);
            return ResultUtil.success(deviceDetailVo);
        }
    }

    @ApiOperation(value = "更新装备库", notes = "可以通过这个接口更新装备库")
    @PostMapping("/updateDeviceLibrary")
    public ResponseEntity updateDeviceLibrary(@RequestBody DeviceEditVo deviceEditVo) {
        DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(deviceEditVo.getDeviceId());
        //更新装备信息
        if (deviceEditVo.getUpdateVoList() != null) {
            DeviceLibraryUpdateVo libraryUpdateVo = deviceEditVo.getUpdateVoList();
            if (libraryUpdateVo.getInvisibleRange() != null) {
                deviceLibraryEntity.setInvisibleRange(libraryUpdateVo.getInvisibleRange());
            }
            if (libraryUpdateVo.getLifeStatus() != null) {
                deviceLibraryEntity.setLifeStatus(libraryUpdateVo.getLifeStatus());
            }
            if (libraryUpdateVo.getLocationUnit()!=null){
                deviceLibraryEntity.setLocationUnit(libraryUpdateVo.getLocationUnit());
            }
            if (libraryUpdateVo.getManageStatus()!=null){
                deviceLibraryEntity.setManageStatus(libraryUpdateVo.getManageStatus());
            }
            if (libraryUpdateVo.getMatchingRange()!=null){
                deviceLibraryEntity.setMatchingRange(libraryUpdateVo.getMatchingRange());
            }
            if (libraryUpdateVo.getModel()!=null){
                deviceLibraryEntity.setModel(libraryUpdateVo.getModel());
            }
            if (libraryUpdateVo.getName()!=null){
                deviceLibraryEntity.setName(libraryUpdateVo.getName());
            }
            if (libraryUpdateVo.getOwnUnit()!=null){
                deviceLibraryEntity.setOwnUnit(libraryUpdateVo.getOwnUnit());
            }
            if (libraryUpdateVo.getProdNumber()!=null){
                deviceLibraryEntity.setProdNumber(libraryUpdateVo.getProdNumber());
            }
            if (libraryUpdateVo.getSecretLevel()!=null){
                deviceLibraryEntity.setSecretLevel(libraryUpdateVo.getSecretLevel());
            }
            if (libraryUpdateVo.getSeqNumber()!=null){
                deviceLibraryEntity.setSeqNumber(libraryUpdateVo.getSeqNumber());
            }
            if (libraryUpdateVo.getStorageType()!=null){
                deviceLibraryEntity.setStorageType(libraryUpdateVo.getStorageType());
            }
            if (libraryUpdateVo.getType()!=null){
                deviceLibraryEntity.setType(libraryUpdateVo.getType());
            }
            deviceLibraryService.update(deviceLibraryEntity);
        }
        //添加绑定配件
        if (deviceEditVo.getPartAddIdList()!=null){
            for (Integer id:deviceEditVo.getPartAddIdList()) {
                if (id>0) {
                    DeviceLibrary d = deviceLibraryService.getOne(id);
                    if (deviceLibraryEntity.getIsPart()==0&&d.getIsPart()==1&&d.getPartParentId()==null){
                        d.setPartParentId(deviceEditVo.getDeviceId());
                        deviceLibraryService.update(d);
                    }
                    if (deviceLibraryEntity.getIsPart()==1&&d.getIsPart()==0){
                        deviceLibraryEntity.setPartParentId(id);
                        deviceLibraryService.update(deviceLibraryEntity);
                    }
                }
            }
        }
        //删除和配件的绑定
        if (deviceEditVo.getPartIdDeleteList()!=null){
            for (Integer id:deviceEditVo.getPartIdDeleteList()) {
                if (id>0) {
                    DeviceLibrary d = deviceLibraryService.getOne(id);
                    if (d.getIsPart()==1&&d.getPartParentId().equals(deviceEditVo.getDeviceId())){
                        d.setPartParentId(null);
                        deviceLibraryService.update(d);
                    }
                    if (deviceLibraryEntity.getIsPart()==1&&d.getIsPart()==0&&deviceLibraryEntity.getPartParentId().equals(id)){
                        deviceLibraryEntity.setPartParentId(null);
                        deviceLibraryService.update(deviceLibraryEntity);
                    }
                }
            }
        }
        return ResultUtil.success("更新成功");
    }

    @ApiOperation(value = "通过表面号查询配件", notes = "通过表面号查询配件")
    @GetMapping("/selectPart/{rfid}")
    public ResponseEntity selectPart(@PathVariable("rfid") String rfid) {
        List<DeviceLibrary> libraryEntities = deviceLibraryDao.getAllByRfidSurfaceId(rfid);
        List<DeviceLibrary> deviceLibraryEntityList = libraryEntities.stream().filter(deviceLibraryEntity -> deviceLibraryEntity.getIsPart() == 1).collect(Collectors.toList());
        return ResultUtil.success(deviceLibraryEntityList);
    }

    @ApiOperation(value = "通过表面号查询装备", notes = "通过表面号查询装备")
    @GetMapping("/selectDevice/{rfid}")
    public ResponseEntity selectDevice(@PathVariable("rfid") String rfid) {
        List<DeviceLibrary> libraryEntities = deviceLibraryDao.getAllByRfidSurfaceId(rfid);
        List<DeviceLibrary> deviceLibraryEntityList = libraryEntities.stream().filter(deviceLibraryEntity -> deviceLibraryEntity.getIsPart() == 0).collect(Collectors.toList());
        return ResultUtil.success(deviceLibraryEntityList);
    }

    @ApiOperation(value = "查询维修报废换新装备", notes = "查询装备")
    @GetMapping("/select/newChange/{id}")
    public ResponseEntity selectNewChangeDevice(@PathVariable("id") int id) {
        DeviceLibrary deviceLibrary = deviceLibraryService.getOne(id);
        List<DeviceLibrary> deviceLibraries = deviceLibraryDao.getAllByTypeAndNameAndModel(deviceLibrary.getType(), deviceLibrary.getName(), deviceLibrary.getModel());
        return ResultUtil.success(deviceLibraries);
    }
}
