package com.tykj.dev.device.library.subject.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备查询类")
public class DeviceLibrarySelectVo extends CustomPage {

    @ApiModelProperty(value = "操作人",example = "1")
    public Integer UserAId;

    @ApiModelProperty(value = "审核人",example = "1")
    public Integer UserBId;

    @ApiModelProperty(value = "型号",example = "bmxx")
    public String model;

    @ApiModelProperty(value = "类型",example = "1")
    public Integer type;

    @ApiModelProperty(value = "密级",example = "1")
    public Integer secretLevel;

    @ApiModelProperty(value = "可见范围(应用领域)",example = "1")
    public Integer invisibleRange;

    @ApiModelProperty(value = "名称",example = "BM-1")
    public String name;

    @ApiModelProperty(value = "配用范围",example = "1")
    public Integer matchingRange;

    @ApiModelProperty(value = "入库类型",example = "1")
    public Integer storageType;

    @ApiModelProperty(value = "管理状态",example = "1")
    public Integer manageStatus;

    @ApiModelProperty(value = "单位id",example = "1")
    public Integer unitId;

    @ApiModelProperty(value = "区域id",example = "1")
    public Integer areaId;

    @ApiModelProperty(value = "模糊查询内容",example = "测试")
    public String content;

    @ApiModelProperty(value = "发起时间",example = "2020-10-10 01:10:10")
    public Date startTime;

    @ApiModelProperty(value = "确认时间",example = "2020-10-10 01:10:10")
    public Date endTime;

    @ApiModelProperty(value = "装备状态",example = "1,2,3,4")
    public List<Integer> lifeStatus;

    @ApiModelProperty(value = "列装id")
    private Integer packingId;

    @ApiModelProperty(value = "所在单位")
    private String locationUnit;

    @ApiModelProperty(value = "所属单位")
    private String ownUnit;

    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId;
}
