package com.tykj.dev.device.repair.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.repair.service.RepairBillService;
import com.tykj.dev.device.repair.subject.domin.RepairBill;
import com.tykj.dev.device.repair.subject.vo.RepairBillSelectVo;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/business")
@AutoDocument
@Api(tags = "业务模块",description = "业务模块")
public class RepairBillSelectController {

    @Autowired
    private RepairBillService repairBillService;

    @ApiOperation(value = "查询维修单", notes = "可以通过这个接口查询维修单")
    @PostMapping(value = "/archives/repair/summary")
    public ResponseEntity selectRepairBill(@RequestBody RepairBillSelectVo repairBillSelectVo) {
        return ResultUtil.success(repairBillService.getPage(repairBillSelectVo, repairBillSelectVo.getPageable()));
    }

    @ApiOperation(value = "查询维修单详情", notes = "可以通过这个接口查询维修单详情")
    @GetMapping(value = "/archives/repair/detail/{id}")
    public ResponseEntity selectRepairBillDetail(@PathVariable("id") int id){
        List<Object> list = new ArrayList<>();
        //获取维修单
        RepairBill repairBill = repairBillService.getOne(id);
        return null;
    }
}
