package com.tykj.dev.device.train.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.train.entity.vo.ConditionsTrainVo;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName TrainController.java
 * @Description TODO
 * @createTime 2020年08月11日 21:42:00
 */
@RestController
@RequestMapping(value = "/user/train")
@AutoDocument
@Api(tags = "专管员培训",description = "培训接口")
public class TrainController {


    @Autowired
    TrainThemeService trainThemeService;
//    @Autowired
//    JobService jobService;
    @Autowired
    MgrcertService mgrcertService;


    @Autowired
    UnitsDao unitsDao;

    /**
     * 培训列表查询接口（分页）
     *
     * @return
     */
    @PostMapping("/summary/page")
    public ResponseEntity trainThemeVoResponseEntity(@RequestBody ConditionsTrainVo conditionsTrainVo) {

        return ResponseEntity.ok(trainThemeService.findTrainPageVo(conditionsTrainVo));
    }

    /**
     * 培训详情接口
     *
     * @param trainThemeId 培训id
     */
    @GetMapping("/detail/{trainThemeId}")
    public ResponseEntity trainThemeVoResponseEntity(@PathVariable Integer trainThemeId) {

        return ResponseEntity.ok(trainThemeService.findById(trainThemeId));
    }

}
