package com.tykj.dev.device.user.base.ret;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserConditionsVo.java
 * @Description 用户列表查询接口
 * @createTime 2020年08月23日 16:07:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户查询条件对象", description = "用户查询条件信息")
@Builder
public class UserConditionsVo {
    @ApiModelProperty(value = "单位id", name = "unitsId", example = "12321L")
    private Integer unitsId;
    @ApiModelProperty(value = "页码", name = "page", example = "12321L")
    private Integer page;
    @ApiModelProperty(value = "条数", name = "size", example = "12321L")
    private Integer size;
    @ApiModelProperty(value = "模糊搜索", name = "dim", example = "12321L")
    private String dim;

}
