package com.tykj.dev.rfid.entity.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class InputOutpuLogSelectVo
 * @packageName com.tykj.dev.rfid.entity.vo
 **/
@Data
@ApiModel("出入库报警查询类")
public class InputOutpuLogSelectVo extends CustomPage {

    @ApiModelProperty(value = "告警类型(0:入库异常,1:出库异常)")
    private List<Integer> warningType;

    @ApiModelProperty(value = "模糊查询")
    private String content;

    @ApiModelProperty("查询开始时间")
    private Date startTime;

    @ApiModelProperty("查询结束时间")
    private Date endTime;

    public LibraryWarningLogSelectVo toWarningVo(){
        LibraryWarningLogSelectVo libraryWarningLogSelectVo = new LibraryWarningLogSelectVo();
        BeanUtils.copyProperties(this,libraryWarningLogSelectVo);
        if (this.warningType==null){
            libraryWarningLogSelectVo.setWarningType(Arrays.asList(0,1));
        }
        return libraryWarningLogSelectVo;
    }
}
