/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.FileUtil;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.device.internal.NullProgressMonitor;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesList;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesZpl;
import com.zebra.sdk.printer.internal.ZebraFileConnection;
import com.zebra.sdk.printer.internal.ZebraFileConnectionImpl;
import com.zebra.sdk.util.internal.FileUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileUtilA
implements FileUtil {
    protected Connection printerConnection;
    private static final String LEGACY_FILE_DIR_KEYWORD = "Directory";
    private static final String EPOCH_FILE_DIR_KEYWORD = "DIR";

    public FileUtilA(Connection connection) {
        this.printerConnection = connection;
    }

    @Override
    public void sendFileContents(String string) throws ConnectionException {
        this.sendFileContents(string, new NullProgressMonitor());
    }

    @Override
    public void sendFileContents(String string, ProgressMonitor progressMonitor) throws ConnectionException {
        ZebraFileConnection zebraFileConnection = this.getFileConnection(string);
        InputStream inputStream = null;
        try {
            inputStream = ((ZebraFileConnectionImpl)zebraFileConnection).openInputStream();
            int n = zebraFileConnection.fileSize();
            FileUtilities.sendFileContentsInChunks(this.printerConnection, progressMonitor, inputStream, n);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public abstract String[] retrieveFileNames() throws ConnectionException, ZebraIllegalArgumentException;

    @Override
    public abstract String[] retrieveFileNames(String[] var1) throws ConnectionException, ZebraIllegalArgumentException;

    public PrinterFilePropertiesList retrieveFilePropertiesFromPrinter() throws ConnectionException, ZebraIllegalArgumentException {
        return this.extractFilePropertiesFromDirResult(SGD.DO("file.dir", "", this.printerConnection));
    }

    public PrinterFilePropertiesList extractFilePropertiesFromDirResult(String string) throws ZebraIllegalArgumentException {
        if (string == null) {
            throw new ZebraIllegalArgumentException("No files found.");
        }
        PrinterFilePropertiesList printerFilePropertiesList = new PrinterFilePropertiesList();
        if (string.contains(EPOCH_FILE_DIR_KEYWORD)) {
            Pattern pattern = Pattern.compile("\\*\\s+([^\\s]+\\:)([^\\s]+)\\.([^\\s]+)\\s+(\\d+)", 8);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                printerFilePropertiesList.add(new PrinterFilePropertiesZpl(matcher.group(1), matcher.group(2), matcher.group(3), Long.parseLong(matcher.group(4))));
            }
        } else if (string.contains(LEGACY_FILE_DIR_KEYWORD)) {
            Pattern pattern = Pattern.compile("\\s+([^\\s]+)\\s+\\.([^\\s]+)\\s+(\\d+)", 8);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                printerFilePropertiesList.add(new PrinterFilePropertiesZpl("", matcher.group(1), matcher.group(2), Long.parseLong(matcher.group(3))));
            }
        } else {
            throw new ZebraIllegalArgumentException("No files found.");
        }
        return printerFilePropertiesList;
    }

    protected ZebraFileConnection getFileConnection(String string) throws ConnectionException {
        return new ZebraFileConnectionImpl(string);
    }
}

