package com.tykj.dev.device.confirmcheck.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * DeviceCheckStatVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:13 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CheckStatVo {

    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 父标题
     */
    private String title;

    /**
     * 子标题
     */
    private String subtitle;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Date createTime;

    private Date updateTime;

    private Integer createUserId;

    private Integer updateUserId;

    /**
     * 核查装备详情
     */
    private List<CheckDeviceStatVo> deviceStatVoList;

    public CheckStatVo(Integer id, String title, String subtitle, Date startTime, Date endTime, List<CheckDeviceStatVo> deviceStatVoList) {
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = startTime;
        this.endTime = endTime;
        this.deviceStatVoList = deviceStatVoList;
    }

    public static CheckStatVo empty() {
        List<CheckDeviceStatVo> emptyList = new ArrayList<>();
        return new CheckStatVo(0, "无指定数据", "无指定数据", null, null, emptyList);
    }

    /**
     * Vo转Do
     */
    public DeviceCheckStat toDo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        //复制基本信息
        DeviceCheckStat initialStat = mapper.map(this, DeviceCheckStat.class);
        //数据转JSON并赋值
        String jsonString = JacksonUtil.toJSon(this.deviceStatVoList);
        initialStat.setStatInfo(jsonString);
        return initialStat;
    }
}
