package com.tykj.dev.device.user.subject.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.ret.UserUpdatePw;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.RoleService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserRoleService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.device.user.util.LogoutUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserController.java
 * @Description TODO
 * @createTime 2020年07月28日 09:02:00
 */
@RestController
@AutoDocument
@Api(tags = "用户模块", description = "提供用户相关的接口")
@RequestMapping("/user")
@Slf4j
public class UserController {
    @Autowired
    UserService userService;

    @Autowired
    RoleService roleService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    UnitsService unitsService;

   @Autowired
   LogoutUtil logout;
//    @PostMapping(value = "/login")
//    @ApiOperation(value = "用户新增接口", notes = "添加成功返回用户对象")
//    public ResponseEntity loginUser(@RequestBody LoginUser loginUser){
//        User user=userService.findByUserName(loginUser.getUserName());
//        if (user==null){
//            return ResponseEntity.status(201).body(null);
//        }else if (!user.getMPassWord().equals(loginUser.getUserName())){
//            return ResponseEntity.status(202).body(null);
//        }
//        Units units=  unitsService.findById(user.getUnitsId());
//        //查询权限的步骤
//        UserRe userRe=new UserRe(user.getUserId(),user.getUserName(),user.getName(),units,new Permissions());
//
//        return ResponseEntity.ok(userRe);
//    }

    @ApiOperation(value = "用户登出")
    @GetMapping("/userLogout")
    public void logout() {
        log.info("调用登出接口");
        logout.logout();
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "用户新增接口", notes = "添加成功返回用户对象")
    public ResponseEntity saveUser(@RequestBody User user) {
        return ResponseEntity.ok(userService.save(user));
    }

    @GetMapping(value = "/delete/{userId}")
    @ApiOperation(value = "用户删除接口", notes = "删除返回true，false")
    public ResponseEntity deleteUser(@PathVariable Integer userId) {
        return ResponseEntity.ok(userService.delete(userId));
    }

    @PostMapping(value = "/update")
    @ApiOperation(value = "用户更新接口", notes = "更新成功返回用户对象")
    public ResponseEntity updateUser(@RequestBody User user) {
        return ResponseEntity.ok(userService.update(user));
    }

    @GetMapping(value = "/findAll")
    @ApiOperation(value = "所有用户查询接口", notes = "成功返回用户对象集合")
    public ResponseEntity findAllUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
//        log.info("当前登入对象：{}",securityUser.getCurrentUserInfo().getUsername());
        return ResponseEntity.ok(userService.findAll());
    }

//    @GetMapping(value = "/findAll/{userId}")
//    @ApiOperation(value = "根据用户id查询同级用户信息", notes = "成功返回用户对象集合")
//    public ResponseEntity findAll(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId){
////        log.info("当前登入对象：{}",securityUser.getCurrentUserInfo().getUsername());
//        return ResponseEntity.ok(userService.findByUserId(userId));
//    }


    @GetMapping(value = "/findAll/{unitsId}")
    @ApiOperation(value = "根据单位查询用户(下拉)", notes = "成功返回用户对象集合")
    public ResponseEntity findAll2(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer unitsId) {
//        log.info("当前登入对象：{}",securityUser.getCurrentUserInfo().getUsername());
        return ResponseEntity.ok(userService.findByUniteId(unitsId));
    }

    @GetMapping(value = "/find/user")
    @ApiOperation(value = "查询当前登入用户信息", notes = "成功返回用户对象")
    public ResponseEntity findUserId(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResponseEntity.ok(securityUser.getCurrentUserInfo());
    }

    @GetMapping(value = "/findAll/units/{userId}")
    @ApiOperation(value = "根据用户id查询同级用户接口(下拉)", notes = "成功返回用户对象集合")
    public ResponseEntity findAll1(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findByUserId(userId));
    }


    @GetMapping(value = "/archives/update/password")
    @ApiOperation(value = "修改用户密码", notes = "返回修改结果")
    public ResponseEntity updatePassword(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody UserUpdatePw userUpdatePw) {

        Integer core = userService.updatePw(userUpdatePw);
        switch (core) {
            case -1:
                return ResponseEntity.ok("原密码不对，请重新修改");
            case -2:
                return ResponseEntity.ok("没有查询的对应的用户");
        }
        return ResponseEntity.ok("修改密码成功");
    }

    @GetMapping(value = "/get/train/{userId}")
    @ApiOperation(value = "根据用户id查询下级用户列表", notes = "成功返回UserTrainVo对象集合")
    public ResponseEntity getFind(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findByIdUserTarinVo(userId));
    }

    @GetMapping(value = "/get/trainUnits/{userId}")
    @ApiOperation(value = "根据用户id查询下级单位列表", notes = "成功返回UnitsTrainVo对象集合")
    public ResponseEntity getFindTrainVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findByIdUnitsTrainVo(userId));
    }

    @GetMapping(value = "/detail/{userId}")
    @ApiOperation(value = "根据用户id查询用户详情", notes = "成功返回UnitsTrainVo对象集合")
    public ResponseEntity getFindMemberThatVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId) {

        return ResponseEntity.ok(userService.findById(userId));
    }

//    @PostMapping(value = "/update")
//    @ApiOperation(value = "修改用户信息", notes = "成功返回UnitsTrainVo对象集合")
//    public ResponseEntity getFindMemberThatVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody MemberThat memberThat){
//        userService.update(memberThat.toUserVo());
//        return ResponseEntity.ok(memberThat);
//    }

    @GetMapping("/findAll/superiorList")
    @ApiOperation(value = "根据用户ID查询上级单位用户", notes = "List<UserSuperiorVo>")
    public ResponseEntity getFindMemberThatVo(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {

        return ResponseEntity.ok(userService.findUserSuperiorVo(securityUser.getCurrentUserInfo().getUserId()));
    }

}
