package com.tykj.dev.confirmcheck;

import com.google.common.collect.Lists;
import com.tykj.dev.device.confirmcheck.controller.DeviceCheckController;
import com.tykj.dev.device.confirmcheck.entity.vo.CheckBillVo;
import com.tykj.dev.union.MockTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;

import static com.tykj.dev.misc.utils.JacksonUtil.toJSon;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

/**
 * DeviceCheckControllerTest.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/15 at 11:17 上午
 */
@SuppressWarnings("ALL")
@WithMockUser(username = "shena", password = "qwer1234")
class DeviceCheckControllerTest extends MockTest {

    @Autowired
    private DeviceCheckController checkController;

    @Autowired
    protected MockMvc mockMvc;


    @Test
    void startManualCheck() throws Exception {


        CheckBillVo param = new CheckBillVo();
        param.setUnitId(1);
        param.setAreaRange(Lists.newArrayList(1));
        param.setCheckTitle("单元测试手动核查");
        param.setRemark("这是一段测试用的数据");
        param.setUserAId(1);
        param.setUserBId(2);

        // 测试
        RequestBuilder request;

        // 1、get查一下user列表，应该为空
        request = get("/check/confirm/check/bill")
                .contentType(MediaType.APPLICATION_JSON)
                .content(toJSon(param));
        mockMvc.perform(request)
                .andExpect(status().isOk());
    }

    @Test
    void checkUserA() {
    }

    @Test
    void checkUserB() {
    }

    @Test
    void checkUserC() {
    }
}