package com.tykj.dev.device.library.subject.Dto;

import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.task.subject.vo.FileVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceLogDto {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(value = "日志类型(默认0为装备日志,1为设备日志)")
    private Integer type = 0;

    @ApiModelProperty(value = "装备id")
    private Integer deviceId;

    @ApiModelProperty(value = "操作描述")
    private String remark;

    @ApiModelProperty(value = "附件信息")
    private List<FileVo> fileVoList;

    @ApiModelProperty(value = "操作人")
    private Integer createUserId;

    @ApiModelProperty(value = "操作时间")
    private Date createTime;

    /**
     * dto类转化为do类
     */
    public DeviceLog toDo(){
        DeviceLog deviceLog = new DeviceLog();
        deviceLog.setType(this.type);
        deviceLog.setDeviceId(this.deviceId);
        deviceLog.setRemark(this.remark);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ǵ");
        for (FileVo f:this.fileVoList) {
            stringBuffer.append(f.getFileName());
            stringBuffer.append("Ǒ");
            stringBuffer.append(f.getFileUrl());
            stringBuffer.append("Ǒ");
            stringBuffer.append(f.getTitle());
            stringBuffer.append("Ǵ");
        }
        deviceLog.setFileDetail(stringBuffer.toString());
        return deviceLog;
    }

    public DeviceLogDto(Integer deviceId, String remark, List<FileVo> fileVoList) {
        this.deviceId = deviceId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }

    public DeviceLogDto(Integer type, Integer deviceId, String remark, List<FileVo> fileVoList) {
        this.type = type;
        this.deviceId = deviceId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }
}
