package com.tykj.dev.device.packing.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.PackingLibraryConfirmVo;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySaveVo;
import com.tykj.dev.device.packing.subject.vo.PartSaveVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@Api(tags = "列装管理模块",description = "列装管理接口")
@AutoDocument
@RequestMapping("/packing")
public class PackingController {

    @Autowired
    PackingLibraryService packingLibraryService;

    @Autowired
    TaskService taskService;

    @Autowired
    UserUtils userUtils;

    @Autowired
    UserPublicService userPublicService;

//    @Autowired
//    DeviceLogService deviceLogService;

    @ApiOperation(value = "新增列装",notes = "可以通过这个接口发起列装")
    @PostMapping("/addPackingLibrary")
    public ResponseEntity<PackingLibrary> addPackingLibrary(@RequestBody PackingLibrarySaveVo packingLibrarySaveVo){
        PackingLibrary p = packingLibrarySaveVo.toDo();
        p.setUseraId(userUtils.getCurrentUserId());
        PackingLibrary packingLibraryEntity = packingLibraryService.addEntity(p);
        for (PartSaveVo part:packingLibrarySaveVo.getPartList()) {
            PackingLibrary p2 = new PackingLibrary();
            BeanUtils.copyProperties(p,p2);
            BeanUtils.copyProperties(part,p2);
            p2.setId(null);
            p2.setIsPart(1);
            p2.setPartParentId(packingLibraryEntity.getId());
            packingLibraryService.addEntity(p2);
        }
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        userIds.add(packingLibrarySaveVo.getUserbId());
        TaskBto taskBto = new TaskBto(StatusEnum.PACKING_CONFIRM.id,"列装业务",null,".",packingLibraryEntity.getId(),1,userUtils.getCurrentUnitId(),1,null,userIds);
        Task saveEntity = taskService.start(taskBto);
//        LogVo bussinessLogVo = new LogVo();
//        bussinessLogVo.setDeviceId(0);
//        bussinessLogVo.setFileDetail("Ǵ");
//        bussinessLogVo.setRemark("发起列装");
//        bussinessLogVo.setTaskId(saveEntity.getId());
//        deviceLogService.addLog(bussinessLogVo);
        return ResultUtil.success(packingLibraryEntity);
    }

    @ApiOperation(value = "列装审核",notes = "可以通过这个接口进行列装审核")
    @PostMapping("/confirmPackingLibrary")
    public ResponseEntity<String> confirmPackingLibrary(@RequestBody PackingLibraryConfirmVo packingLibraryConfirmVo){
        TaskBto taskBto = taskService.get(packingLibraryConfirmVo.getTaskId());
        if(packingLibraryConfirmVo.getStatus()==0){
            taskService.update(taskService.moveToEnd(taskBto));
            PackingLibrary packingLibraryEntity = packingLibraryService.getOne(taskBto.getBillId());
            packingLibraryEntity.setPackingStatus(2);
            for (PackingLibrary p:packingLibraryService.selectAllPart(taskBto.getBillId())) {
                p.setPackingStatus(2);
            }
            packingLibraryService.selectAllPart(taskBto.getBillId());
            packingLibraryService.update(packingLibraryEntity);
//            LogVo bussinessLogVo = new LogVo();
//            bussinessLogVo.setDeviceId(0);
//            bussinessLogVo.setFileDetail("Ǵ");
//            bussinessLogVo.setRemark("列装审核成功");
//            bussinessLogVo.setTaskId(taskEntity.getId());
//            deviceLogService.addLog(bussinessLogVo);
            return ResultUtil.success("审核通过列装成功");
        }
        if (packingLibraryConfirmVo.getStatus()==1){
            taskService.moveToArchive(taskBto);
            PackingLibrary packingLibraryEntity = packingLibraryService.getOne(taskBto.getBillId());
            packingLibraryEntity.setPackingStatus(1);
            for (PackingLibrary p:packingLibraryService.selectAllPart(taskBto.getBillId())) {
                p.setPackingStatus(2);
            }
            packingLibraryService.update(packingLibraryEntity);
            taskService.update(taskBto);
//            LogVo bussinessLogVo = new LogVo();
//            bussinessLogVo.setDeviceId(0);
//            bussinessLogVo.setFileDetail("Ǵ");
//            bussinessLogVo.setRemark("列装审核失败");
//            bussinessLogVo.setTaskId(taskEntity.getId());
//            deviceLogService.addLog(bussinessLogVo);
            return ResultUtil.success("列装审核失败");
        }
        else {
            return ResultUtil.failed("status只能为0或1");
        }
    }
}
