package com.tykj.dev.device.storage.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for storage_bill
 * 入库账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update storage_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("入库账单")
public class StorageBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 申请文号
	*/
	@ApiModelProperty(value = "申请文号")
	private String applyNumber;
	/**
	* 批复文号
	*/
	@ApiModelProperty(value = "批复文号")
	private String replayNumber;
	/**
	* 配发单位
	*/
	@ApiModelProperty(value = "配发单位")
	private String sendUnit;
	/**
	* 配发时间
	*/
	@ApiModelProperty(value = "配发时间")
	private Date sendTime;
	/**
	* 发件方id
	*/
	@ApiModelProperty(value = "发件方")
	private String sendUserId;
	/**
	* 收件方id(A岗位)
	*/
	@ApiModelProperty(value = "收件方id(A岗位)")
	private Integer receiveUseraId;
	/**
	* 收件方id(B岗位)
	*/
	@ApiModelProperty(value = "收件方id(B岗位)")
	private Integer receiveUserbId;
	/**
	* 入库状态(0:待审核，1:审核失败，2:已入库)
	*/
	@ApiModelProperty(value = "入库状态(0:待审核，1:审核失败，2:已入库)")
	private Integer storageStatus;
	/**
	* 账单文件地址URL
	*/
	@ApiModelProperty(value = "账单文件地址URL")
	private String fileName;
	/**
	* 账单文件地址URL
	*/
	@ApiModelProperty(value = "账单文件地址URL")
	private String fileUrl;
	/**
	 * 入库附件文件名
	 */
	@ApiModelProperty(value = "入库附件文件名")
	private String receiveFileName;
	/**
	 * 入库附件文件地址URL
	 */
	@ApiModelProperty(value = "入库附件文件地址URL")
	private String receiveFileUrl;
	/**
	* 待入库装备数量
	*/
	@ApiModelProperty(value = "待入库装备数量")
	private Integer storagingCount;
	/**
	* 已入库装备数量
	*/
	@ApiModelProperty(value = "已入库装备数量")
	private Integer storagedCount;
	/**
	* 入库详情(列装主键idx列装数量x装备主键id(字符,作为不同列装的分隔符)),例如1x2x3x4,2x1x5,意为列装库中id为1的入库2件(装备id分别为3，4),列装库中id为2的入库1件(装备id为5)
	*/
	@ApiModelProperty(value = "入库详情(装备主键id+核对结果(0缺失1无误2不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
	private String storageDetail;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private java.sql.Timestamp createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private java.sql.Timestamp updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "经办人")
	@Transient
	private String receiveUserA;

	@ApiModelProperty(value = "审核人")
	@Transient
	private String receiveUserB;

}
