package com.tykj.dev.device.task.subject.common;

import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 业务状态枚举
 */

@AllArgsConstructor
public enum StatusEnum {
    /**
     * 业务完结
     */
    END(9999,"业务完结"),

    /**
     * 业务封存
     */
    ARCHIVE(8888,"业务封存"),

    /**
     * 列装待审核
     */
    PACKING_CONFIRM(100,"列装待审核"),

    /**
     * 入库待审核
     */
    STORAGE_CONFIRM(200,"入库待审核"),

    /**
     * 配发出库待审核
     */
    ALLOT_SEND_CONFIRM(300,"配发出库待审核"),

    /**
     * 配发中
     */
    ALLOTING(301,"配发中"),

    /**
     * 配发入库待审核
     */
    ALLOT_RECEIVE_CONFIRM(302,"配发入库待审核"),

    /**
     * 待自查
     */
    WAIT_SELF_CHECK(400,"待自查"),

    /**
     * 自查待审核
     */
    SELF_CHECK_CONFIRM(401,"自查待审核");

    public Integer id;

    public String name;
}
