package com.tykj.dev.device.user.base.ret;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserTranitVo.java
 * @Description TODO
 * @createTime 2020年08月18日 17:35:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "培训选人列表实体")
public class UserTrainVo {
    /**
     * 用户
     */

    @ApiModelProperty(value = "用户数据ID", name = "userId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer userId;

    /**
     * 真实名称
     */
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;


    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;


    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务",name = "position")
    private Integer position;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private String unitsName;

    /**
     * 培训状态 0.已培训 1.已过期 2.未培训 3.快过期
     */
    private Integer trainStatus;

    /**
     * 0 是 1 否
     */
    private Integer isMustJoin;
}
