package com.tykj.dev.device.library.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.library.subject.vo.DeviceStatisticsVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceLibraryService {

    /**
     * @param deviceLibraryEntity
     * 添加装备
     */
    DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable
     * 获取装备分页
     */
    Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable
     * 获取标签管理分页
     */
    Page<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable
     * 获取核心装备分页
     */
    Page<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable
     * 获取装备统计分页
     */
    Page<DeviceStatisticsVo> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * 获取所有存在的装备名称
     */
    List<String> getAllName();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * 获取单位装备列表
     */
    List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * 获取所有区域装备列表
     */
    List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 获取单位自查装备列表
     */
    List<DeviceLibrary> getCheckList();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * 获取可配发装备列表
     */
    List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param id 入库单id
     * 根据入库单Id查询装备列表
     */
    List<DeviceLibrary> getListByBillId(Integer id);

    /**
     * @param deviceLibraryEntity
     * 更新装备信息
     */
    DeviceLibrary update(DeviceLibrary deviceLibraryEntity);

    /**
     * @param id 装备主键Id
     * 通过id查询某件装备
     */
    DeviceLibrary getOne(Integer id);

    /**
     * @param id 装备主键id
     * 逻辑删除某件装备
     */
    void delete(Integer id);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * 不以父子结构返回单位装备列表
     */
    List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 查询拥有装备的所有单位
     */
    List<String> getAllUnit();
}
