package com.tykj.dev.device.matching.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for matching_device_library
 * 配套设备库
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update matching_device_library set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配套设备库")
public class MatchingDeviceLibrary {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 绑定装备的主键id
	*/
	@ApiModelProperty(value = "绑定装备的主键id")
	private Integer deviceId;
	/**
	* 设备类型
	*/
	@ApiModelProperty(value = "设备类型")
	private String type;
	/**
	* 型号
	*/
	@ApiModelProperty(value = "型号")
	private String model;
	/**
	* 设备名称
	*/
	@ApiModelProperty(value = "设备名称")
	private String name;
	/**
	* 创建单位
	*/
	@ApiModelProperty(value = "创建单位")
	private String createUnit;
	/**
	* 设备序列号
	*/
	@ApiModelProperty(value = "设备序列号")
	private String seqNumber;
	/**
	* rfid表面号
	*/
	@ApiModelProperty(value = "rfid表面号")
	private String rfidSurfaceId;
	/**
	* rfid卡号
	*/
	@ApiModelProperty(value = "rfid卡号")
	private String rfidCardId;
	/**
	* 生命状态,0,-入库待审核,1-入库审核失败,2-在库
	*/
	@ApiModelProperty(value = "生命状态,0,-入库待审核,1-入库审核失败,2-在库")
	private Integer lifeStatus;
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	/**
	 * 关联装备rfid表面号
	 */
	@ApiModelProperty(value = "关联装备rfid表面号")
	@Transient
	private String relateDevice;
}
