package com.tykj.dev.device.task.subject.bto;

import com.tykj.dev.device.task.subject.common.GlobalMap;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskBto {

    @ApiModelProperty(value = "主键id")
    private Integer id;

    @ApiModelProperty(value = "任务状态")
    private Integer billStatus;

    @ApiModelProperty(value = "任务标题")
    private String title;

    @ApiModelProperty(value = "父任务主键id")
    private Integer parentTaskId;

    @ApiModelProperty(value = "所有节点任务id组合,例如.1.2.,意为从根节点到当前节点所经历的节点为1和2")
    private String nodeIdDetail;

    @ApiModelProperty(value = "对应账单ID")
    private Integer billId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer businessType;

    @ApiModelProperty(value = "所属单位")
    private Integer ownUnit;


    @ApiModelProperty(value = "数字类型，用于代表指针目前的下标")
    private Integer currentPoint;

    @ApiModelProperty(value = "自定义信息，针对不同业务需要保存一些自定信息")
    private String customInfo;

    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "置顶用户id的List")
    private List<Integer> topFlagDetailList;

    @ApiModelProperty(value = "阅读过用户id的List")
    private List<Integer> userReadDetailList;

    @ApiModelProperty(value = "工作涉及人员id")
    private List<Integer> involveUserIdList;

    public TaskBto(Integer billStatus, String title, Integer parentTaskId, String nodeIdDetail, Integer billId, Integer businessType, Integer ownUnit, Integer currentPoint, String customInfo, List<Integer> involveUserIdList) {
        this.billStatus = billStatus;
        this.title = title;
        this.parentTaskId = parentTaskId;
        this.nodeIdDetail = nodeIdDetail;
        this.billId = billId;
        this.businessType = businessType;
        this.ownUnit = ownUnit;
        this.currentPoint = currentPoint;
        this.customInfo = customInfo;
        this.involveUserIdList = involveUserIdList;
    }


    public TaskBto(Integer status, String title, Integer parentTaskId, String nodeIdDetail, Integer businessType, Integer billId, Integer ownUnit, int startUserId) {
        this.billStatus = status;
        this.title = title;
        this.parentTaskId = parentTaskId;
        this.nodeIdDetail = nodeIdDetail;
        this.businessType = businessType;
        this.billId = billId;
        this.ownUnit = ownUnit;
        List<Integer> involveUserIdList = new ArrayList<>();
        involveUserIdList.add(startUserId);
        this.involveUserIdList = involveUserIdList;
        this.currentPoint = 0;
    }

    /**
     * bto类转化为do类
     */
    public Task toDo() {
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        Task task = modelMapper.map(this, Task.class);
        //set组合字段
        task.setInvolveUsers(StringSplitUtil.idListToString(this.involveUserIdList));
        task.setUserReadDetail(StringSplitUtil.idListToString(this.userReadDetailList));
        task.setTopFlagDetail(StringSplitUtil.idListToString(this.topFlagDetailList));
        return task;
    }

    /**
     * bto类转化为vo类
     */
    public TaskUserVo toVo() {
        UserPublicService userPublicService = SpringUtils.getBean("userPublicServiceImpl");
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        TaskUserVo taskUserVo = modelMapper.map(this, TaskUserVo.class);
        //set vo字段
        if (userPublicService != null) {
            taskUserVo.setStartUnit(userPublicService.findUnitsNameByUserId(this.createUserId));
        }
        taskUserVo.setStatus(GlobalMap.getStatusEnumMap().get(this.billStatus).name);
        return taskUserVo;
    }

    /**
     * @return 最后一个参与该任务的人员id, 用于任务状态变化时人员不变的情况
     */
    public Integer getLastUserId() {
        return involveUserIdList.get(involveUserIdList.size() - 1);
    }

    /**
     * @return 第一个参与该任务的人员id, 用于任务状态变化时需要返回初始状态的情况
     */
    public Integer getFirstUserId() {
        return involveUserIdList.get(0);
    }
}
