package com.tykj.dev.device.taskselect.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.matching.service.MatchingDeviceBillService;
import com.tykj.dev.device.matching.service.MatchingDeviceLibraryService;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.selfcheck.service.SelfCheckBillService;
import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import com.tykj.dev.device.storage.service.StorageBillService;
import com.tykj.dev.device.storage.subject.domin.StorageBill;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块",description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class TaskSelectController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private PackingLibraryService packingLibraryService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private StorageBillService storageBillService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private DeviceApplyBillService deviceApplyBillService;

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private SelfCheckBillService selfCheckBillService;

    @Autowired
    private MatchingDeviceBillService matchingDeviceBillService;

    @Autowired
    private MatchingDeviceLibraryService matchingDeviceLibraryService;



    @ApiOperation(value = "查询业务对应页面的数据",notes = "可以通过这个接口查询业务对应页面的数据")
    @GetMapping("/manage/detail/{id}")
    public ResponseEntity<ResultObj> selectData(@PathVariable("id") int taskId){
        TaskBto taskBto = taskService.get(taskId);
        Integer bussinessType = taskBto.getBusinessType();
        Integer billId = taskBto.getBillId();
        List<Object> list = new ArrayList<>();
        list.add(taskBto);
        switch (bussinessType){
            case 1:
                PackingLibrary packingLibraryEntity = packingLibraryService.getOne(billId);
                packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUseraId()).getName());
                packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserbId()).getName());
                list.add(packingLibraryEntity);
                List<PackingLibrary> packingLibraryEntities= packingLibraryService.selectAllPart(billId);
                list.add(packingLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            case 2:
                StorageBill storageBillEntity = storageBillService.getOne(billId);
                storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUseraId()).getName());
                storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserbId()).getName());
                list.add(storageBillEntity);
                String str = storageBillEntity.getStorageDetail();
                List<Integer> list1= StringSplitUtil.userIdSplit(str);
                List<DeviceLibrary> libraryEntities = new ArrayList<>();
                for (Integer id:list1) {
                    DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(id);
                    libraryEntities.add(deviceLibraryEntity);
                }
                list.add(libraryEntities);
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            case 3:
                if (taskBto.getBillId()==0){
                    TaskBto applyTask = taskService.get(taskBto.getParentTaskId());
                    DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
                    List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
                    List<Integer> packingIdList = new ArrayList<>();
                    List<Integer> numList = new ArrayList<>();
                    List<PackingLibrary> packingLibraryEntityList = new ArrayList<>();
                    if (idList.size()>0){
                        for (int i=1;i<=idList.size();i++) {
                            if (i%2==1){
                                packingIdList.add(idList.get(i-1));
                            }
                            else {
                                numList.add(idList.get(i-1));
                            }
                        }
                    }
                    if (packingIdList.size()==numList.size()){
                        for (int i=0;i<packingIdList.size();i++) {
                            PackingLibrary p = packingLibraryService.getOne(packingIdList.get(i));
                            p.setApplyNum(numList.get(i));
                            packingLibraryEntityList.add(p);
                        }
                    }
                    list.add(packingLibraryEntityList);
                    //查询可配发相同类型装备列表
                    list.add(deviceLibraryService.getAllotList(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibrary::getPackingId)).collect(Collectors.toList()));
                    return ResponseEntity.ok(new ResultObj(list,"查询成功"));
                }
                AllotBill allotBillEntity = allotBillService.getOne(billId);
                allotBillEntity.setSenderUserA(userPublicService.getOne(allotBillEntity.getSendUseraId()).getName());
                allotBillEntity.setSenderUserB(userPublicService.getOne(allotBillEntity.getSendUserbId()).getName());
                allotBillEntity.setReceiveUserA(userPublicService.getOne(allotBillEntity.getReceiveUseraId()).getName());
                if (allotBillEntity.getReceiveUserbId()!=null){
                    allotBillEntity.setReceiveUserB(userPublicService.getOne(allotBillEntity.getReceiveUserbId()).getName());
                }
                list.add(allotBillEntity);
                String str2 = allotBillEntity.getAllotCheckDetail();
                String[] strings1 = str2.split("x");
                List<DeviceLibrary> deviceLibraryEntities = new ArrayList<>();
                for (String s:strings1) {
                    if (s.length()>=2&& "1".equals(s.substring(s.length()-1))) {
                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
                        DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(id);
                        deviceLibraryEntity.setCheckResult(checkResult);
                        deviceLibraryEntities.add(deviceLibraryEntity);
                    }
                }
                list.add(deviceLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            case 4:
                SelfCheckBill selfExaminationBillEntity = selfCheckBillService.getOne(billId);
                if (selfExaminationBillEntity.getUseraId()!=0) {
                    selfExaminationBillEntity.setCheckUser(userPublicService.getOne(selfExaminationBillEntity.getUseraId()).getName());
                }
                if (selfExaminationBillEntity.getUserbId()!=0) {
                    selfExaminationBillEntity.setConfirmUser(userPublicService.getOne(selfExaminationBillEntity.getUserbId()).getName());
                }
                list.add(selfExaminationBillEntity);
                String str3 = selfExaminationBillEntity.getCheckDetail();
                String str4 = selfExaminationBillEntity.getNewDeviceDetail();
                String[] split = str3.split("x");
                if (str4!=null) {
                    String[] split2 = str4.split("\\.");
                    List<DeviceLibrary> newDeviceList = new ArrayList<>();
                    for (String rfid:split2){
                        if (rfid.length()>0){
                            DeviceLibrary d = new DeviceLibrary();
                            d.setCheckResult(2);
                            d.setSeqNumber("-");
                            d.setName("-");
                            d.setType(0);
                            d.setRfidSurfaceId("-");
                            d.setProdNumber("-");
                            d.setRfidCardId(rfid);
                            newDeviceList.add(d);
                        }
                    }
                    list.add(newDeviceList);
                }
                if (str4==null){
                    List<DeviceLibrary> newDeviceList = new ArrayList<>();
                    list.add(newDeviceList);
                }
                List<DeviceLibrary> libraryEntities1 = new ArrayList<>();
                for (String s:split) {
                    if (s.length()>=2) {
                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
                        DeviceLibrary deviceLibraryEntity = deviceLibraryService.getOne(id);
                        deviceLibraryEntity.setCheckResult(checkResult);
                        libraryEntities1.add(deviceLibraryEntity);
                    }
                }
                list.add(libraryEntities1);
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            case 19:
                MatchingDeviceBill matchingDeviceBillEntity = matchingDeviceBillService.getOne(billId);
                list.add(matchingDeviceBillEntity);
                List<Integer> integerList = StringSplitUtil.userIdSplit(matchingDeviceBillEntity.getDeviceDetail());
                List<MatchingDeviceLibrary> matchingDeviceLibraryEntities = new ArrayList<>();
                if (integerList.size()>0){
                    for (Integer id:integerList) {
                        if (id>0){
                            matchingDeviceLibraryEntities.add(matchingDeviceLibraryService.getOne(id));
                        }
                    }
                }
                list.add(matchingDeviceLibraryEntities);
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            case 9:
                DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(taskBto.getBillId());
                deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUseraId()).getName());
                list.add(deviceApplyBillEntity);
                List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
                List<Integer> packingIdList = new ArrayList<>();
                List<Integer> numList = new ArrayList<>();
                List<PackingLibrary> packingLibraryEntityList = new ArrayList<>();
                if (idList.size()>0){
                    for (int i=1;i<=idList.size();i++) {
                        if (i%2==1){
                            packingIdList.add(idList.get(i-1));
                        }
                        else {
                            numList.add(idList.get(i-1));
                        }
                    }
                }
                if (packingIdList.size()==numList.size()){
                    for (int i=0;i<packingIdList.size();i++) {
                        PackingLibrary p = packingLibraryService.getOne(packingIdList.get(i));
                        p.setApplyNum(numList.get(i));
                        packingLibraryEntityList.add(p);
                    }
                }
                list.add(packingLibraryEntityList);
                list.add(deviceLibraryService.getAllotList(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibrary::getPackingId)).collect(Collectors.toList()));
                return ResponseEntity.ok(new ResultObj(list,"查询成功"));
            default: return null;
        }
    }
}
