package com.tykj.dev.device.train.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.train.entity.vo.HandoverVo;
import com.tykj.dev.device.train.service.TrainThemeService;
import com.tykj.dev.device.user.base.ret.HandoverUser;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.MgrcertService;
import com.tykj.dev.device.user.subject.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName HandoverController.java
 * @Description 工作交接服务层
 * @createTime 2020年08月19日 09:36:00
 */
@RestController
@RequestMapping(value = "/user/handover/")
@AutoDocument
@Api(tags = "工作交接",description = "工作交接")
public class HandoverController {

    @Autowired
    TrainThemeService trainThemeService;
    @Autowired
    MgrcertService mgrcertService;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserService userService;

    @GetMapping(value = "/{userId}")
    @ApiOperation(value = "根据用户id查询交接用户详情", notes = "成功返回handoverUser对象集合")
    public ResponseEntity<HandoverUser> getHandoverUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @PathVariable Integer userId){

        return ResponseEntity.ok(userService.findByIdHandoverUser(userId));
    }

    @PostMapping(value = "/job")
    @ApiOperation(value = "用户工作交接")
    public ResponseEntity<String> getHandoverUser(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser, @RequestBody HandoverVo handoverVo){

//        jobService.findByIdsList(handoverVo.getCommissionJobIds()).forEach(
//                jobEntity -> {
//                    if (jobEntity.getBelongUserId()==handoverVo.getHandoverUserId()) {
//                        jobEntity.setBelongUserId(handoverVo.getBeHandoverUserId());
//                        jobEntity.setInvoleUserId(jobEntity.getInvoleUserId().replace(handoverVo.getHandoverUserId().toString(),handoverVo.getBeHandoverUserId().toString()));
//                        jobService.update(jobEntity);
//                    }
//                }
//        );
//        jobService.findByIdsList(handoverVo.getTrackingJobIds()).forEach(
//                jobEntity -> {
//                        jobEntity.setInvoleUserId(jobEntity.getInvoleUserId().replace(handoverVo.getHandoverUserId().toString(),handoverVo.getBeHandoverUserId().toString()));
//                        jobService.update(jobEntity);
//                }
//        );

        return ResponseEntity.ok("成功");
    }




}
