package com.tykj.dev.device.user.config;

import com.tykj.dev.device.user.subject.entity.Role;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.entity.UserRole;
import com.tykj.dev.device.user.subject.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zjm
 */
@Service
public class MyUserDetailsServiceImpl implements UserDetailsService {
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RolePermissionsService rolePermissionsService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    UnitsService unitsService;


    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException{
        System.out.println("userService验证:" + username);
          SecurityUser securityUser= new SecurityUser();
            User user = userService.findByUserName(username);
        if(user==null){
            throw new UsernameNotFoundException("用户名不正确");
        }else {
                List<UserRole> userRoles = userRoleService.findByUserId(user.getUserId());
                List<Integer> roleIds = new ArrayList<>();
                if(userRoles!=null){
                    for (UserRole userRole : userRoles) {
                        roleIds.add(userRole.getRoleId());
                    }
                }
//              user.setPassword(bCryptPasswordEncoder.encode(user.getPassword()));
//                List<SimpleGrantedAuthority> list = new ArrayList<>();
                List<Role> roles = roleService.findAllByRoles(roleIds);
//                List<RolePermissions> rolePermissions = rolePermissionsService.findAllByRoleIds(roleIds);
//                List<Integer> PermissionsIds = new ArrayList<>();
//                if(rolePermissions!=null){
//                    for (RolePermissions permissions : rolePermissions) {
//                        if(!PermissionsIds.contains(permissions.getPermissionsId())){
//                            PermissionsIds.add(permissions.getPermissionsId());
//                        }
//                    }
//                }
//
//                List<Permissions> permissionsList = permissionsService.findAllByPerissionsIds(PermissionsIds);
//                permissionsList.forEach(permissions -> {
//                    list.add(new SimpleGrantedAuthority(permissions.getPermissionsDes()));
//                });
//                 user.setArrayList(list);
            user.setUnits(unitsService.findById(user.getUnitsId()));
            securityUser.setCurrentUserInfo(user);
            securityUser.setRoleList(roles);
            securityUser.setUsername(username);
            return securityUser;
        }


    }
}
