package com.tykj.dev.device.user.subject.controller;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaController.java
 * @Description TODO
 * @createTime 2020年09月04日 13:34:00
 */

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.user.base.ret.AreaInstitutions;
import com.tykj.dev.device.user.base.ret.AreaVo;
import com.tykj.dev.device.user.base.ret.PermissionsType;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.AreaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * 区域视图层
 */
@RestController
@AutoDocument
@Api(tags = "区域模块", description = "提供区域模块的接口")
@RequestMapping("/area")
public class AreaController {
    @Autowired
    AreaService areaService;

    @GetMapping(value = "/area/units")
    @ApiOperation(value = "查询权限接口，按照类型划分，具体字段查看model" ,notes = "成功返回分类的权限对象")
    public ResponseEntity<List<AreaVo>> addPermissions(@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        return ResponseEntity.ok(areaService.findAll(securityUser.getCurrentUserInfo().getUnits().getAreaId()));
    }

}
