package com.tykj.dev.misc.utils;

import com.tykj.dev.misc.base.ResultObj;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ResultMessage
 * @packageName com.example.hello.demo.resultObject
 **/
public class ResultUtil<T> {


    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity<ResultObj> success(T data) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add(HttpHeaders.CONTENT_TYPE, "application/json;charset=UTF-8");
        return new ResponseEntity<>(new ResultObj(data), httpHeaders, HttpStatus.OK);
    }

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity<ResultObj> success(T data, HttpHeaders headers) {
        return new ResponseEntity<>(new ResultObj(data), headers, HttpStatus.OK);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<ResultObj> failed() {
        return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<ResultObj> failed(T content) {
        return new ResponseEntity<>(new ResultObj(content), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<T> failed(HttpStatus httpStatus) {
        return new ResponseEntity<>(httpStatus);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity<ResultObj> failed(HttpStatus httpStatus, T content) {
        return new ResponseEntity<>(new ResultObj(content), httpStatus);
    }

    /**
     * 参数验证失败返回结果
     */
    public static <T> ResponseEntity<ResultObj> validateFailed(T content) {
        return failed(HttpStatus.INTERNAL_SERVER_ERROR, content);
    }


    /**
     * 未登录返回结果
     */
    public static <T> ResponseEntity<T> unauthorized() {
        return failed(HttpStatus.UNAUTHORIZED);
    }

    /**
     * 未授权返回结果
     */
    public static <T> ResponseEntity<T> forbidden() {
        return failed(HttpStatus.FORBIDDEN);

    }



}
