/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.fileConversion.internal.ColonSignifiesEndStream;
import com.zebra.sdk.util.fileConversion.internal.DZ_DataProviderStream;
import com.zebra.sdk.util.fileConversion.internal.DataFormatSpecifier;
import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.ZplUnwrapperStreamBase;
import com.zebra.sdk.util.internal.Base64;
import com.zebra.sdk.util.internal.CustomGZIPInputStream;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.io.IOException;
import java.io.InputStream;

public class DZ_UnwrapperStream
extends ZplUnwrapperStreamBase {
    private InputStream sourceStream;

    public DZ_UnwrapperStream(InputStream inputStream) throws IOException {
        this.sourceStream = inputStream;
        if (this.sourceStream == null) {
            throw new IOException("input stream is null");
        }
        DZ_DataProviderStream dZ_DataProviderStream = new DZ_DataProviderStream(this.sourceStream);
        this.dataUnwrapperStream = dZ_DataProviderStream.getDataFormatSpecifier() == DataFormatSpecifier.MIME_UNCOMPRESSED ? new Base64.InputStream(new ColonSignifiesEndStream(dZ_DataProviderStream), 0) : (dZ_DataProviderStream.getDataFormatSpecifier() == DataFormatSpecifier.MIME_COMPRESSED ? new CustomGZIPInputStream(new Base64.InputStream(new ColonSignifiesEndStream(dZ_DataProviderStream), 0)) : dZ_DataProviderStream);
        try {
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(dZ_DataProviderStream.getFilenameOnPrinter());
            this.unwrappedType = PrinterFileType.getUnwrappedType(printerFilePath.getExtension());
            if (printerFilePath.getFileName().length() > 8) {
                this.consumeLargeDzHeader();
            } else {
                this.consumeShortDzHeader();
            }
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new IOException(zebraIllegalArgumentException);
        }
        this.fileNameOnPrinter = dZ_DataProviderStream.getFilenameOnPrinter();
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            while ((n = this.sourceStream.read()) != -1) {
            }
        }
        return n;
    }

    private void consumeShortDzHeader() throws IOException {
        for (int i = 0; i < 16; ++i) {
            this.dataUnwrapperStream.read();
        }
    }

    private void consumeLargeDzHeader() throws IOException {
        for (int i = 0; i < 24; ++i) {
            this.dataUnwrapperStream.read();
        }
    }

    @Override
    protected PrinterWrappingType getTypeToUnwrap() {
        return PrinterWrappingType.DZ;
    }
}

